package com.sencha.gxt.explorer.client.layout;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.resources.ThemeStyles;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.theme.base.client.panel.FramedPanelAppearance;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.ContentPanel.ContentPanelAppearance;
import com.sencha.gxt.widget.core.client.container.HorizontalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HorizontalLayoutContainer.HorizontalLayoutData;

@Detail(name = "HorizontalLayout", icon = "columnlayout", category = "Layouts")
public class HorizontalLayoutExample implements IsWidget, EntryPoint {

  public void onModuleLoad() {
    RootPanel.get().add(asWidget());
  }

  @Override
  public Widget asWidget() {
    VerticalPanel vp = new VerticalPanel();
    vp.setSpacing(10);

    ContentPanel panel = new ContentPanel(GWT.<ContentPanelAppearance>create(FramedPanelAppearance.class));
    panel.setHeadingText("HorizontalLayout Example");
    panel.setPixelSize(400, 300);
    panel.setCollapsible(true);

    HorizontalLayoutContainer c = new HorizontalLayoutContainer();
    panel.setWidget(c);

    HTML label1 = new HTML("Test Label 1");
    label1.getElement().getStyle().setProperty("whiteSpace", "nowrap");
    label1.addStyleName(ThemeStyles.getStyle().border());
    label1.addStyleName("pad-text white-bg");

    Label label2 = new Label("Test Label 2");
    label2.addStyleName(ThemeStyles.getStyle().border());
    label2.addStyleName("pad-text white-bg");

    Label label3 = new Label("Test Label 3");
    label3.addStyleName(ThemeStyles.getStyle().border());
    label3.addStyleName("pad-text white-bg");

    c.add(label1, new HorizontalLayoutData(-1, 1, new Margins(4)));
    c.add(label2, new HorizontalLayoutData(1, 1, new Margins(4, 0, 4, 0)));
    c.add(label3, new HorizontalLayoutData(-1, 1, new Margins(4)));

    vp.add(panel);

    return vp;
  }

}
