package com.sencha.gxt.explorer.client.grid;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.editor.client.Editor.Path;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.PropertyAccess;
import com.sencha.gxt.examples.resources.client.TestData;
import com.sencha.gxt.examples.resources.client.model.Stock;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.GroupingView;

@Detail(name = "Grouping Grid", icon = "grouping", category = "Grid")
public class GroupingGridExample implements EntryPoint, IsWidget {
  
  interface StockProperties extends PropertyAccess<Stock> {
    @Path("lastTrans")
    ValueProvider<Stock, Date> date();

    @Path("name")
    ModelKeyProvider<Stock> key();

    ValueProvider<Stock, Double> open();

    ValueProvider<Stock, Double> change();

    ValueProvider<Stock, String> name();

    ValueProvider<Stock, String> symbol();

    ValueProvider<Stock, String> industry();
  }

  @Override
  public Widget asWidget() {
    StockProperties properties = GWT.create(StockProperties.class);
    ListStore<Stock> store = new ListStore<Stock>(properties.key());

    store.addAll(TestData.getCompanies());

    List<ColumnConfig<Stock, ?>> cfgs = new ArrayList<ColumnConfig<Stock, ?>>();
    ColumnConfig<Stock, String> name = new ColumnConfig<Stock, String>(properties.name());
    name.setHeader("Name");
    name.setCell(new TextCell());
    cfgs.add(name);

    ColumnConfig<Stock, Double> price = new ColumnConfig<Stock, Double>(properties.open());
    price.setHeader("Price");
    cfgs.add(price);
    ColumnConfig<Stock, Double> change = new ColumnConfig<Stock, Double>(properties.change());
    change.setHeader("Change");
    cfgs.add(change);

    final ColumnConfig<Stock, String> industry = new ColumnConfig<Stock, String>(properties.industry());
    industry.setHeader("Industry");
    cfgs.add(industry);

    ColumnModel<Stock> cm = new ColumnModel<Stock>(cfgs);

    final GroupingView<Stock> view = new GroupingView<Stock>();
    view.setShowGroupedColumn(false);
    view.setForceFit(true);

    Grid<Stock> grid = new Grid<Stock>(store, cm);
    grid.setView(view);
    Scheduler.get().scheduleFinally(new ScheduledCommand() {
      @Override
      public void execute() {
        view.groupBy(industry);
      }
    });

    ContentPanel panel = new ContentPanel();
    panel.setHeadingHtml("Grouping Example");
    panel.setSize("700", "450");
    panel.add(grid);
    panel.addStyleName("margin-10");
    panel.setCollapsible(true);
    return panel;
  }

  @Override
  public void onModuleLoad() {
    RootPanel.get().add(this);
  }

}
