package com.sencha.gxt.explorer.client.grid;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.gwt.cell.client.Cell.Context;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor.Path;
import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.i18n.shared.DateTimeFormat.PredefinedFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.TextButtonCell;
import com.sencha.gxt.cell.core.client.form.DateCell;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.PropertyAccess;
import com.sencha.gxt.examples.resources.client.TestData;
import com.sencha.gxt.examples.resources.client.model.Plant;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.DateTimePropertyEditor;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.info.Info;

@Detail(name = "Cell Grid", icon = "cellgrid", category = "Grid")
public class CellGridExample implements IsWidget, EntryPoint {

  interface PlaceProperties extends PropertyAccess<Plant> {
    ValueProvider<Plant, Date> available();

    @Path("name")
    ModelKeyProvider<Plant> key();

    ValueProvider<Plant, String> name();
  }

  private static final PlaceProperties properties = GWT.create(PlaceProperties.class);
  private ListStore<Plant> store;

  @Override
  public Widget asWidget() {
    ColumnConfig<Plant, String> cc1 = new ColumnConfig<Plant, String>(properties.name(), 100, "Name");
    
    TextButtonCell button = new TextButtonCell();
    button.addSelectHandler(new SelectHandler() {
      
      @Override
      public void onSelect(SelectEvent event) {
        Context c = event.getContext();
        int row = c.getIndex();
        Plant p = store.get(row);
        Info.display("Event", "The " + p.getName() + " was clicked.");
      }
    });
    cc1.setCell(button);

    DateCell dateCell = new DateCell();
    dateCell.setPropertyEditor(new DateTimePropertyEditor(DateTimeFormat.getFormat(PredefinedFormat.DATE_SHORT)));

    ColumnConfig<Plant, Date> cc2 = new ColumnConfig<Plant, Date>(properties.available(), 100, "Date");

    cc2.setCell(dateCell);

    List<ColumnConfig<Plant, ?>> l = new ArrayList<ColumnConfig<Plant, ?>>();
    l.add(cc1);
    l.add(cc2);
    ColumnModel<Plant> cm = new ColumnModel<Plant>(l);

    store = new ListStore<Plant>(properties.key());
    store.addAll(TestData.getPlants());

    Grid<Plant> view = new Grid<Plant>(store, cm);
    view.getView().setForceFit(true);

    ContentPanel cp = new ContentPanel();
    cp.setHeadingText("Cell Grid");
    cp.setWidget(view);
    cp.setPixelSize(500, 400);
    cp.addStyleName("margin-10");
    return cp;
  }

  @Override
  public void onModuleLoad() {
    RootPanel.get().add(asWidget());
  }
}
