package com.sencha.gxt.explorer.client.forms;

import java.util.Date;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.PropertyAccess;
import com.sencha.gxt.examples.resources.client.TestData;
import com.sencha.gxt.examples.resources.client.model.Stock;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.NumberPropertyEditor.DoublePropertyEditor;
import com.sencha.gxt.widget.core.client.form.SpinnerField;
import com.sencha.gxt.widget.core.client.form.TextArea;
import com.sencha.gxt.widget.core.client.form.validator.MinDateValidator;
import com.sencha.gxt.widget.core.client.form.validator.MinLengthValidator;

@Detail(name = "Forms Example (UiBinder)", icon = "forms", category = "Forms", files = "FormsUiBinderExample.ui.xml")
public class FormsUiBinderExample implements IsWidget, EntryPoint {

  interface StockProperties extends PropertyAccess<Stock> {
    LabelProvider<Stock> name();

    ModelKeyProvider<Stock> symbol();
  }

  interface MyUiBinder extends UiBinder<Widget, FormsUiBinderExample> {
  }

  private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

  StockProperties props = GWT.create(StockProperties.class);
  ListStore<Stock> store = new ListStore<Stock>(props.symbol());

  @UiField(provided = true)
  ComboBox<Stock> combo = new ComboBox<Stock>(store, props.name());

  @UiField
  DateField date;

  @UiField
  TextArea description;

  @UiField(provided = true)
  SpinnerField<Double> spinnerField = new SpinnerField<Double>(new DoublePropertyEditor());

  public Widget asWidget() {
    store.addAll(TestData.getStocks());

    Widget widget = uiBinder.createAndBindUi(this);

    date.addValidator(new MinDateValidator(new Date()));
    description.addValidator(new MinLengthValidator(10));
    spinnerField.setIncrement(.1d);
    spinnerField.setMinValue(-10d);
    spinnerField.setMaxValue(10d);
    spinnerField.getPropertyEditor().setFormat(NumberFormat.getFormat("00.0"));

    return widget;
  }

  public void onModuleLoad() {
    RootPanel.get().add(asWidget());
  }

}
