package com.sencha.gxt.explorer.client.forms;

import java.util.Date;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.i18n.shared.DateTimeFormat.PredefinedFormat;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.util.DateWrapper;
import com.sencha.gxt.core.client.util.ToggleGroup;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.PropertyAccess;
import com.sencha.gxt.examples.resources.client.TestData;
import com.sencha.gxt.examples.resources.client.model.Stock;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.Slider;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.form.CheckBox;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.form.NumberField;
import com.sencha.gxt.widget.core.client.form.PasswordField;
import com.sencha.gxt.widget.core.client.form.NumberPropertyEditor.DoublePropertyEditor;
import com.sencha.gxt.widget.core.client.form.NumberPropertyEditor.IntegerPropertyEditor;
import com.sencha.gxt.widget.core.client.form.Radio;
import com.sencha.gxt.widget.core.client.form.SpinnerField;
import com.sencha.gxt.widget.core.client.form.TextArea;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.form.TimeField;
import com.sencha.gxt.widget.core.client.form.validator.MinDateValidator;
import com.sencha.gxt.widget.core.client.form.validator.MinLengthValidator;
import com.sencha.gxt.widget.core.client.info.Info;

@Detail(name = "Forms Example", icon = "forms", category = "Forms")
public class FormsExample implements IsWidget, EntryPoint {

  interface StockProperties extends PropertyAccess<Stock> {
    LabelProvider<Stock> name();

    ModelKeyProvider<Stock> symbol();
  }

  private VerticalPanel vp;

  public Widget asWidget() {
    vp = new VerticalPanel();
    vp.setSpacing(10);
    createForm1();
    createForm2();
    return vp;
  }

  public void onModuleLoad() {
    RootPanel.get().add(asWidget());
  }

  private void createForm1() {
    FramedPanel panel = new FramedPanel();
    panel.setHeadingText("Simple Form");
    panel.setWidth(350);
    panel.setBodyStyle("background: none; padding: 5px");

    VerticalLayoutContainer p = new VerticalLayoutContainer();
    panel.add(p);

    TextField firstName = new TextField();
    firstName.setAllowBlank(false);
    firstName.setEmptyText("Enter your name...");
    p.add(new FieldLabel(firstName, "Name"), new VerticalLayoutData(1, -1));

    TextField email = new TextField();
    email.setAllowBlank(false);
    p.add(new FieldLabel(email, "Email"), new VerticalLayoutData(1, -1));
    
    PasswordField password = new PasswordField();
    p.add(new FieldLabel(password, "Password"), new VerticalLayoutData(1, -1));

    NumberField<Integer> age = new NumberField<Integer>(new IntegerPropertyEditor());
    age.setAllowBlank(false);

    p.add(new FieldLabel(age, "Age"), new VerticalLayoutData(1, -1));

    StockProperties props = GWT.create(StockProperties.class);
    ListStore<Stock> store = new ListStore<Stock>(props.symbol());
    store.addAll(TestData.getStocks());

    ComboBox<Stock> combo = new ComboBox<Stock>(store, props.name());
    combo.addValueChangeHandler(new ValueChangeHandler<Stock>() {

      @Override
      public void onValueChange(ValueChangeEvent<Stock> event) {
        Info.display("Selected", "You selected " + event.getValue());
      }
    });
    combo.setAllowBlank(true);
    combo.setForceSelection(true);
    combo.setTriggerAction(TriggerAction.ALL);

    p.add(new FieldLabel(combo, "Company"), new VerticalLayoutData(1, -1));

    DateField date = new DateField();
    date.addValueChangeHandler(new ValueChangeHandler<Date>() {

      @Override
      public void onValueChange(ValueChangeEvent<Date> event) {
        String v = event.getValue() == null ? "nothing" : DateTimeFormat.getFormat(PredefinedFormat.DATE_MEDIUM).format(event.getValue());
        Info.display("Selected",
            "You selected " + v);

      }
    });
    date.addValidator(new MinDateValidator(new Date()));
    p.add(new FieldLabel(date, "Birthday"), new VerticalLayoutData(1, -1));

    TimeField time = new TimeField();
    time.setMinValue(new DateWrapper().clearTime().addHours(8).asDate());
    time.setMaxValue(new DateWrapper().clearTime().addHours(18).addSeconds(1).asDate());
    p.add(new FieldLabel(time, "Time"), new VerticalLayoutData(1, -1));

    Slider slider = new Slider();
    slider.setMinValue(40);
    slider.setMaxValue(90);
    slider.setValue(0);
    slider.setIncrement(5);
    slider.setMessage("{0} inches tall");
    p.add(new FieldLabel(slider, "Size"), new VerticalLayoutData(1, -1));

    CheckBox check1 = new CheckBox();
    check1.setBoxLabel("Classical");

    CheckBox check2 = new CheckBox();
    check2.setBoxLabel("Rock");
    check2.setValue(true);

    CheckBox check3 = new CheckBox();
    check3.setBoxLabel("Blues");

    HorizontalPanel hp = new HorizontalPanel();
    hp.add(check1);
    hp.add(check2);
    hp.add(check3);

    p.add(new FieldLabel(hp, "Music"));

    Radio radio = new Radio();
    radio.setBoxLabel("Red");

    Radio radio2 = new Radio();
    radio2.setBoxLabel("Blue");
    radio2.setValue(true);

    hp = new HorizontalPanel();
    hp.add(radio);
    hp.add(radio2);

    p.add(new FieldLabel(hp, "Color"));

    // we can set name on radios or use toggle group
    ToggleGroup toggle = new ToggleGroup();
    toggle.add(radio);
    toggle.add(radio2);

    TextArea description = new TextArea();
    description.setPreventScrollbars(true);
    description.addValidator(new MinLengthValidator(10));
    p.add(new FieldLabel(description, "Description"), new VerticalLayoutData(1, 100));

    SpinnerField<Double> spinnerField = new SpinnerField<Double>(new DoublePropertyEditor());
    spinnerField.setIncrement(.1d);
    spinnerField.getPropertyEditor().setFormat(NumberFormat.getFormat("00.0"));

    FieldLabel spinLabel = new FieldLabel(spinnerField, "Duration(s)");
    spinnerField.setMinValue(-10d);
    spinnerField.setMaxValue(10d);
    p.add(spinLabel, new VerticalLayoutData(1, -1));

    panel.addButton(new TextButton("Save"));
    panel.addButton(new TextButton("Cancel"));

    vp.add(panel);
  }

  private void createForm2() {
    FramedPanel form2 = new FramedPanel();
    form2.setHeadingText("Simple Form with FieldSets");
    form2.setWidth(350);

    FieldSet fieldSet = new FieldSet();
    fieldSet.setHeadingText("User Information");
    fieldSet.setCollapsible(true);
    form2.add(fieldSet);

    VerticalLayoutContainer p = new VerticalLayoutContainer();
    fieldSet.add(p);

    TextField firstName = new TextField();
    firstName.setAllowBlank(false);
    p.add(new FieldLabel(firstName, "First Name"), new VerticalLayoutData(1, -1));

    TextField lastName = new TextField();
    lastName.setAllowBlank(false);
    p.add(new FieldLabel(lastName, "Last Name"), new VerticalLayoutData(1, -1));

    TextField email = new TextField();
    email.setAllowBlank(false);
    p.add(new FieldLabel(email, "Email"), new VerticalLayoutData(1, -1));

    // TextField<String> company = new TextField<String>();
    // company.setFieldLabel("Company");
    // fieldSet.add(company, formData);
    //
    // TextField<String> email = new TextField<String>();
    // email.setFieldLabel("Email");
    // fieldSet.add(email, formData);

    // form2.add(fieldSet);
    //
    // fieldSet = new FieldSet();
    // fieldSet.setHeading("Phone Numbers");
    // fieldSet.setCollapsible(true);
    //
    // layout = new FormLayout();
    // layout.setLabelWidth(75);
    // fieldSet.setLayout(layout);
    //
    // TextField field = new TextField();
    // field.setFieldLabel("Home");
    // fieldSet.add(field, formData);
    //
    // field = new TextField();
    // field.setFieldLabel("Business");
    // fieldSet.add(field, formData);
    //
    // field = new TextField();
    // field.setFieldLabel("Mobile");
    // fieldSet.add(field, formData);
    //
    // field = new TextField();
    // field.setFieldLabel("Fax");
    // fieldSet.add(field, formData);
    //
    // form2.add(fieldSet);
    // form2.setButtonAlign(HorizontalAlignment.CENTER);

    form2.addButton(new TextButton("Save"));
    form2.addButton(new TextButton("Cancel"));

    vp.add(form2);
  }

}
