package com.sencha.gxt.explorer.client.forms;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.PropertyAccess;
import com.sencha.gxt.examples.resources.client.TestData;
import com.sencha.gxt.examples.resources.client.model.Stock;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.box.MessageBox;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FileUploadField;
import com.sencha.gxt.widget.core.client.form.FormPanel;
import com.sencha.gxt.widget.core.client.form.FormPanel.Encoding;
import com.sencha.gxt.widget.core.client.form.FormPanel.Method;
import com.sencha.gxt.widget.core.client.form.TextField;

@Detail(name = "File Upload", icon = "fileupload", category = "Forms")
public class FileUploadExample implements IsWidget, EntryPoint {

  interface StockProperties extends PropertyAccess<Stock> {
    LabelProvider<Stock> name();

    ModelKeyProvider<Stock> symbol();
  }

  public Widget asWidget() {
    FramedPanel panel = new FramedPanel();
    panel.setHeadingText("File Upload Example");
    panel.setButtonAlign(BoxLayoutPack.CENTER);
    panel.setWidth(350);
    panel.getElement().setMargins(10);

    final FormPanel form = new FormPanel();
    form.setAction("myurl");
    form.setEncoding(Encoding.MULTIPART);
    form.setMethod(Method.POST);
    panel.add(form);

    VerticalLayoutContainer p = new VerticalLayoutContainer();
    form.add(p);

    TextField firstName = new TextField();
    firstName.setAllowBlank(false);
    p.add(new FieldLabel(firstName, "Name"), new VerticalLayoutData(-18, -1));

    final FileUploadField file = new FileUploadField();
    // file.setAllowBlank(false);
    file.setName("uploadedfile");
    p.add(new FieldLabel(file, "File"), new VerticalLayoutData(-18, -1));

    StockProperties props = GWT.create(StockProperties.class);
    ListStore<Stock> store = new ListStore<Stock>(props.symbol());
    store.addAll(TestData.getStocks());

    ComboBox<Stock> combo = new ComboBox<Stock>(store, props.name());
    combo.setTriggerAction(TriggerAction.ALL);

    p.add(new FieldLabel(combo, "Company"), new VerticalLayoutData(-18, -1));

    TextButton btn = new TextButton("Reset");
    btn.addSelectHandler(new SelectHandler() {

      @Override
      public void onSelect(SelectEvent event) {
        form.reset();
        // TODO needs to be part of form panel, ie a Field interface
        file.reset();
      }
    });

    panel.addButton(btn);

    btn = new TextButton("Submit");
    btn.addSelectHandler(new SelectHandler() {

      @Override
      public void onSelect(SelectEvent event) {
        if (!form.isValid()) {
          return;
        }
        // normally would submit the form but for example no server set up to
        // handle the post
        // panel.submit();
        MessageBox box = new MessageBox("File Upload Example", "Your file was uploaded.");
        box.setIcon(MessageBox.ICONS.info());
        box.show();
      }
    });
    panel.addButton(btn);
    return panel;
  }

  public void onModuleLoad() {
    RootPanel.get().add(asWidget());
  }

}
