package com.sencha.gxt.explorer.client.forms;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.PropertyAccess;
import com.sencha.gxt.examples.resources.client.TestData;
import com.sencha.gxt.examples.resources.client.model.Country;
import com.sencha.gxt.examples.resources.client.model.State;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.info.Info;

@Detail(name = "ComboBox", icon = "combobox", category = "Combos")
public class ComboBoxExample implements IsWidget, EntryPoint {

  interface StateProperties extends PropertyAccess<State> {
    ModelKeyProvider<State> abbr();

    LabelProvider<State> name();
  }

  interface CountryProperties extends PropertyAccess<Country> {
    ModelKeyProvider<Country> abbr();

    LabelProvider<Country> name();
  }

  public Widget asWidget() {
    VerticalPanel vp = new VerticalPanel();
    vp.setSpacing(10);

    StateProperties props = GWT.create(StateProperties.class);
    ListStore<State> states = new ListStore<State>(props.abbr());
    states.addAll(TestData.getStates());

    ComboBox<State> combo = new ComboBox<State>(states, props.name());
    combo.addValueChangeHandler(new ValueChangeHandler<State>() {
      @Override
      public void onValueChange(ValueChangeEvent<State> event) {
        Info.display("Selected", "You selected " + (event.getValue() == null ? "nothing" : event.getValue().getName()) + "!");
      }
    });
    combo.setEmptyText("Select a state...");
    combo.setWidth(150);
    combo.setTypeAhead(true);
    combo.setTriggerAction(TriggerAction.ALL);
    vp.add(combo);

    states = new ListStore<State>(props.abbr());
    states.addAll(TestData.getStates());

    combo = new ComboBox<State>(states, props.name(), new LabelProvider<State>() {
      @Override
      public String getLabel(State item) {
        return "<div qtip=\"" + item.getSlogan() + "\" qtitle=\"State Slogan\">" + item.getName() + "</div>";
      }
    });
    combo.addValueChangeHandler(new ValueChangeHandler<State>() {
      @Override
      public void onValueChange(ValueChangeEvent<State> event) {
        Info.display("Selected", "You selected " + (event.getValue() == null ? "nothing" : event.getValue().getName()) + "!");
      }
    });
    combo.setEmptyText("Select a state...");
    combo.setWidth(150);
    combo.setTypeAhead(true);
    combo.setTriggerAction(TriggerAction.ALL);
    vp.add(combo);

    CountryProperties countryProps = GWT.create(CountryProperties.class);

    ListStore<Country> countries = new ListStore<Country>(countryProps.abbr());
    countries.addAll(TestData.getCountries());

    ComboBox<Country> combo2 = new ComboBox<Country>(countries, countryProps.name(), new LabelProvider<Country>() {

      @Override
      public String getLabel(Country item) {
        return "<img width='16' height='11' src='/examples/images/flags/" + item.getAbbr() + ".png" + "" + "'>&nbsp;"
            + item.getName();
      }
    });
    combo2.addValueChangeHandler(new ValueChangeHandler<Country>() {
      @Override
      public void onValueChange(ValueChangeEvent<Country> event) {
        Info.display("Selected", "You selected " + (event.getValue() == null ? "nothing" : event.getValue().getName()) + "!");
      }
    });
    combo2.setWidth(150);
    combo2.setTypeAhead(true);
    combo2.setTriggerAction(TriggerAction.ALL);

    vp.add(combo2);
    return vp;
  }

  public void onModuleLoad() {
    RootPanel.get().add(asWidget());
  }

}
