package com.sencha.gxt.explorer.client.binding;

import java.util.List;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.Style.SelectionMode;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.client.editor.ListStoreEditor;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.PropertyAccess;
import com.sencha.gxt.examples.resources.client.TestData;
import com.sencha.gxt.examples.resources.client.model.Stock;
import com.sencha.gxt.explorer.client.binding.ListViewBindingExample.StockExchange;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.ListView;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FormPanel;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.selection.SelectionChangedEvent;
import com.sencha.gxt.widget.core.client.selection.SelectionChangedEvent.SelectionChangedHandler;

/**
 * Demonstrates using the ListStoreEditor, and some concept of building multiple
 * editors. Note that as currently written, when a Stock object is saved, it
 * will modify the StockExchange's instances, instead of cloning models before
 * editing them.
 */
@Detail(name = "List View Binding", icon = "listviewbinding", category = "Binding")
public class ListViewBindingExample implements EntryPoint, IsWidget, Editor<StockExchange> {
  public static class StockEditor implements IsWidget, Editor<Stock> {

    private FormPanel panel;
    private VerticalLayoutContainer container;

    TextField name;
    TextField symbol;

    private TextButton save;

    public StockEditor() {
      panel = new FormPanel();
      panel.setLabelWidth(50);

      container = new VerticalLayoutContainer();
      panel.setWidget(container);

      name = new TextField();
      symbol = new TextField();

      container.add(new FieldLabel(name, "Name"), new VerticalLayoutData(1, -1));
      container.add(new FieldLabel(symbol, "Symbol"), new VerticalLayoutData(1, -1));

      save = new TextButton("Save");
      save.setEnabled(false);
      container.add(save);

      panel.setLabelWidth(50);
    }

    @Override
    public Widget asWidget() {
      return panel;
    }
  }
  public static class StockExchange {
    private List<Stock> stocks = TestData.getStocks();

    public List<Stock> getStocks() {
      return stocks;
    }

    public void setStocks(List<Stock> stocks) {
      this.stocks = stocks;
    }
  }

  interface ListDriver extends SimpleBeanEditorDriver<StockExchange, ListViewBindingExample> {
  }

  interface StockDriver extends SimpleBeanEditorDriver<Stock, StockEditor> {
  }

  interface StockProperties extends PropertyAccess<Stock> {
    @Path("symbol")
    ModelKeyProvider<Stock> key();

    ValueProvider<Stock, String> name();
  }

  private ListDriver driver = GWT.create(ListDriver.class);

  private StockDriver itemDriver = GWT.create(StockDriver.class);

  private FramedPanel panel;

  ListView<Stock, String> stockList;
  ListStoreEditor<Stock> stocks;

  @Ignore
  StockEditor stockEditor;

  @Override
  public Widget asWidget() {
    if (panel == null) {
      panel = new FramedPanel();
      panel.setHeadingText("ListView Binding");
      panel.setPixelSize(300, 300);
      panel.setBodyBorder(false);

      panel.addStyleName("margin-10");

      VerticalLayoutContainer c = new VerticalLayoutContainer();

      final StockProperties props = GWT.create(StockProperties.class);

      stockList = new ListView<Stock, String>(new ListStore<Stock>(props.key()), props.name());
      stockList.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);

      stocks = new ListStoreEditor<Stock>(stockList.getStore());

      c.add(stockList, new VerticalLayoutData(1, 1));
      stockList.getSelectionModel().addSelectionChangedHandler(new SelectionChangedHandler<Stock>() {
        @Override
        public void onSelectionChanged(SelectionChangedEvent<Stock> event) {
          edit(event.getSelection().get(0));
        }
      });

      stockEditor = new StockEditor();

      stockEditor.save.addSelectHandler(new SelectHandler() {

        @Override
        public void onSelect(SelectEvent event) {
          saveCurrentStock();

        }
      });
      c.add(stockEditor, new VerticalLayoutData(1, -1, new Margins(5)));
      panel.add(c);

      itemDriver.initialize(stockEditor);
      driver.initialize(this);
    }

    driver.edit(new StockExchange());
    return panel;
  }

  @Override
  public void onModuleLoad() {
    RootPanel.get().add(this);
  }

  protected void edit(Stock stock) {
    itemDriver.edit(stock);
    stockEditor.save.setEnabled(true);
  }

  protected void saveCurrentStock() {
    Stock edited = itemDriver.flush();
    if (!itemDriver.hasErrors()) {
      stockEditor.save.setEnabled(false);

      stockList.getStore().update(edited);
    }
  }
}
