package com.sencha.gxt.explorer.client.binding;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.XTemplates;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.examples.resources.client.TestData;
import com.sencha.gxt.examples.resources.client.model.Stock;
import com.sencha.gxt.examples.resources.client.model.StockProperties;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.ValidEvent;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.NumberField;
import com.sencha.gxt.widget.core.client.form.NumberPropertyEditor;
import com.sencha.gxt.widget.core.client.form.NumberPropertyEditor.DoublePropertyEditor;
import com.sencha.gxt.widget.core.client.form.TextField;

@Detail(name = "Basic Binding (UiBinder)", icon = "basicbinding", category = "Binding", files = {
    "BasicBindingExample.html", "BasicBindingUiBinderExample.ui.xml"})
public class BasicBindingUiBinderExample implements IsWidget, EntryPoint, Editor<Stock> {

  interface MyUiBinder extends UiBinder<HorizontalPanel, BasicBindingUiBinderExample> {
  }

  private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

  interface StockDriver extends SimpleBeanEditorDriver<Stock, BasicBindingUiBinderExample> {
  }

  interface StockTemplate extends XTemplates {
    @XTemplate(source = "BasicBindingExample.html")
    SafeHtml drawStock(Stock stock);
  }

  private Stock stock = TestData.getStocks().get(0);

  // editor fields
  @UiField
  TextField name;
  @UiField
  TextField symbol;
  @UiField
  NumberField<Double> last;
  @UiField
  NumberField<Double> change;
  @UiField
  DateField lastTrans;

  @UiField
  @Ignore
  HTML display;
  @UiField(provided = true)
  NumberPropertyEditor<Double> doublePropertyEditor = new DoublePropertyEditor();
  @UiField(provided = true)
  NumberFormat numberFormat = NumberFormat.getFormat("0.00");
  @UiField(provided = true)
  ListStore<Stock> stockStore;
  @UiField(provided = true)
  LabelProvider<Stock> stockLabelProvider;

  private StockDriver driver = GWT.create(StockDriver.class);

  public Widget asWidget() {
    StockProperties props = GWT.create(StockProperties.class);
    stockStore = new ListStore<Stock>(props.key());

    HorizontalPanel hp = uiBinder.createAndBindUi(this);
    hp.setCellWidth(display, "200");
    stockStore.addAll(TestData.getStocks());
    display.setHTML(getUpdatedPanel());

    driver.initialize(this);
    driver.edit(stock);

    return hp;
  }

  public void onModuleLoad() {
    RootPanel.get().add(asWidget());
  }

  @UiHandler("save")
  public void saveClicked(SelectEvent event) {
    driver.flush();
    display.setHTML(getUpdatedPanel());
  }

  @UiHandler("reset")
  public void resetClicked(SelectEvent event) {
    driver.edit(stock);
  }

  @UiHandler("symbol")
  public void validateSymbole(ValidEvent event) {
    String value = symbol.getValue();
    if (value != null && !value.matches("[A-Z]+")) {
      symbol.markInvalid("Symbol must be in all caps");
    }
  }

  private SafeHtml getUpdatedPanel() {
    StockTemplate template = GWT.create(StockTemplate.class);
    return template.drawStock(stock);
  }
}
