package com.sencha.gxt.explorer.client.binding;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.XTemplates;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.PropertyAccess;
import com.sencha.gxt.examples.resources.client.TestData;
import com.sencha.gxt.examples.resources.client.model.Stock;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.NumberField;
import com.sencha.gxt.widget.core.client.form.NumberPropertyEditor.DoublePropertyEditor;
import com.sencha.gxt.widget.core.client.form.TextField;

@Detail(name = "Basic Binding", icon = "basicbinding", category = "Binding", files = "BasicBindingExample.html")
public class BasicBindingExample implements IsWidget, EntryPoint, Editor<Stock> {
  interface StockDriver extends SimpleBeanEditorDriver<Stock, BasicBindingExample> {
  }

  interface StockProperties extends PropertyAccess<Stock> {
    @Path("symbol")
    ModelKeyProvider<Stock> key();

    LabelProvider<Stock> name();
  }

  interface StockTemplate extends XTemplates {
    @XTemplate(source = "BasicBindingExample.html")
    SafeHtml drawStock(Stock stock);
  }

  class SymbolField extends TextField {
    @Override
    protected boolean validateValue(String value) {
      if (value != null && !value.matches("[A-Z]+")) {
        markInvalid("Symbol must be in all caps");
        return false;
      }
      return super.validateValue(value);
    }
  }

  private Stock stock = TestData.getStocks().get(0);
  private HTML display;

  // editor fields
  TextField name;
  SymbolField symbol;
  NumberField<Double> last;
  NumberField<Double> change;
  DateField lastTrans;

  private StockDriver driver = GWT.create(StockDriver.class);

  public Widget asWidget() {
    HorizontalPanel hp = new HorizontalPanel();
    hp.setSpacing(10);

    hp.add(updateDisplay());
    hp.add(createEditor());

    hp.setCellWidth(updateDisplay(), "200");

    driver.initialize(this);
    driver.edit(stock);

    return hp;
  }

  public void onModuleLoad() {
    RootPanel.get().add(asWidget());
  }

  private Widget createEditor() {
    ContentPanel panel = new ContentPanel();

    panel.setWidth(400);
    panel.setBodyStyle("padding: 5px;");
    panel.setHeaderVisible(false);

    VerticalLayoutContainer c = new VerticalLayoutContainer();

    name = new TextField();
    c.add(new FieldLabel(name, "Name"), new VerticalLayoutData(1, -1));

    symbol = new SymbolField();
    symbol.setName("symbol");
    c.add(new FieldLabel(symbol, "Symbol"), new VerticalLayoutData(1, -1));

    last = new NumberField<Double>(new DoublePropertyEditor());
    last.setName("last");
    last.setFormat(NumberFormat.getFormat("0.00"));
    c.add(new FieldLabel(last, "Last"), new VerticalLayoutData(1, -1));

    change = new NumberField<Double>(new DoublePropertyEditor());
    change.setName("change");
    change.setFormat(NumberFormat.getFormat("0.00"));
    c.add(new FieldLabel(change, "Change"), new VerticalLayoutData(1, -1));

    lastTrans = new DateField();
    lastTrans.setName("date");
    c.add(new FieldLabel(lastTrans, "Updated"), new VerticalLayoutData(1, -1));

    StockProperties props = GWT.create(StockProperties.class);
    ListStore<Stock> stockStore = new ListStore<Stock>(props.key());
    stockStore.addAll(TestData.getStocks());

    ComboBox<Stock> scb = new ComboBox<Stock>(stockStore, props.name());
    scb.setForceSelection(true);
    scb.setTypeAhead(true);
    scb.setName("company");
    scb.setTriggerAction(TriggerAction.ALL);
    c.add(new FieldLabel(scb, "Name"), new VerticalLayoutData(1, -1));

    TextButton save = new TextButton("Save");
    save.addSelectHandler(new SelectHandler() {

      @Override
      public void onSelect(SelectEvent event) {
        stock = driver.flush();
        updateDisplay();
      }
    });
    panel.addButton(save);
    TextButton reset = new TextButton("Cancel");
    reset.addSelectHandler(new SelectHandler() {

      @Override
      public void onSelect(SelectEvent event) {
        driver.edit(stock);
      }
    });

    panel.addButton(reset);
    panel.add(c);
    return panel;
  }

  private HTML updateDisplay() {
    if (display == null) {
      display = new HTML();
    }
    StockTemplate template = GWT.create(StockTemplate.class);
    display.setHTML(template.drawStock(stock));
    return display;
  }
}
