package com.sencha.gxt.examples.test.client.chart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor.Path;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.chart.client.chart.Chart;
import com.sencha.gxt.chart.client.chart.Chart.Position;
import com.sencha.gxt.chart.client.chart.Legend;
import com.sencha.gxt.chart.client.chart.axis.NumericAxis;
import com.sencha.gxt.chart.client.chart.axis.TimeAxis;
import com.sencha.gxt.chart.client.chart.series.BarSeries;
import com.sencha.gxt.chart.client.draw.RGB;
import com.sencha.gxt.chart.client.draw.sprite.TextSprite;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.PropertyAccess;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;

public class ChartTest implements EntryPoint, IsWidget {
    
    private static final DataPropertyAccess DATA_ACESSS = GWT.create(DataPropertyAccess.class);
    private static final DateTimeFormat DATE_TIME_FORMAT = DateTimeFormat.getFormat("MM/dd");
    
    public interface DataPropertyAccess extends PropertyAccess<ItemsSold> {
        @Path("date")
        ModelKeyProvider<ItemsSold> dateKey();
        ValueProvider<ItemsSold, Date>date();
        ValueProvider<ItemsSold, Double> asphalt();
        ValueProvider<ItemsSold, Double> cardboard();
        ValueProvider<ItemsSold, Double> cloth();
        ValueProvider<ItemsSold, Double> glass();
        ValueProvider<ItemsSold, Double> metal();
        ValueProvider<ItemsSold, Double> paper();
        ValueProvider<ItemsSold, Double> plastic();
        ValueProvider<ItemsSold, Double> stone();
        ValueProvider<ItemsSold, Double> wood();
    }

    public void onModuleLoad() {
        RootPanel.get().add(asWidget());
    }

    @Override
    public Widget asWidget() {

        final ListStore<ItemsSold> listStore = new ListStore<ItemsSold>(DATA_ACESSS.dateKey());
        listStore.addAll(getData(90, 2000, 10000));
        
        final Chart<ItemsSold> chart = new Chart<ItemsSold>();
        chart.setStore(listStore);
        chart.setChartShadow(true);
     
        final NumericAxis<ItemsSold> axis = new NumericAxis<ItemsSold>();
        axis.setPosition(Position.LEFT);
        axis.addField(DATA_ACESSS.wood());
        TextSprite title = new TextSprite("Sold Items");
        title.setFontSize(18);
        axis.setTitleConfig(title);
        axis.setMinimum(0);
        axis.setMaximum(7000);
        chart.addAxis(axis);
        
        final TimeAxis<ItemsSold> time = new TimeAxis<ItemsSold>();
        time.setPosition(Position.BOTTOM);
        time.setField(DATA_ACESSS.date());
        time.setStartDate(new Date(listStore.get(0).getDate().getTime()));
        time.setEndDate(new Date(listStore.get(listStore.size() -1).getDate().getTime()));
        time.setLabelProvider(new LabelProvider<Date>() {
            @Override
            public String getLabel(Date item) {
                return DATE_TIME_FORMAT.format(item);
            }
        });
        time.setSteps(10);
        chart.addAxis(time);
    
        BarSeries<ItemsSold> column = new BarSeries<ItemsSold>();
        column.setYAxisPosition(Position.LEFT);
        column.addYField(DATA_ACESSS.asphalt());
        column.addYField(DATA_ACESSS.cardboard());
        column.addYField(DATA_ACESSS.cloth());
        column.addYField(DATA_ACESSS.glass());
        column.addYField(DATA_ACESSS.metal());
        column.addYField(DATA_ACESSS.paper());
        column.addYField(DATA_ACESSS.plastic());
        column.addYField(DATA_ACESSS.stone());
        column.addYField(DATA_ACESSS.wood());
        column.addColor(RGB.CYAN);
        column.addColor(RGB.YELLOW);
        column.addColor(RGB.GREEN);
        column.addColor(RGB.MAGENTA);
        column.addColor(RGB.ORANGE);
        column.addColor(RGB.PINK);
        column.addColor(RGB.PURPLE);
        column.addColor(RGB.RED);
        column.addColor(RGB.BLUE);
        column.setLegendTitles(Arrays.asList(new String []{"Asphalt", "Cardboard", "Cloth", "Glass", "Metal", "Paper", "Plastic", "Stone", "Wood"}));
        column.setHighlighting(true);
        column.setColumn(true);
        column.setStacked(true);
        chart.addSeries(column);
        
        Legend<ItemsSold> legend = new Legend<ItemsSold>();
        legend.setPosition(Position.TOP);
        legend.setItemHiding(true);
        chart.setLegend(legend);
        
        FramedPanel framedPanel = new FramedPanel() {{
            monitorWindowResize = true;
            Window.enableScrolling(false);
            setPixelSize(Window.getClientWidth(), Window.getClientHeight() - 150);
            }
        
            @Override
            protected void onWindowResize(int width, int height) {
                setPixelSize(width, height - 150);
            }};
        framedPanel.setHeadingText("Daily Items Sold - 90 Days");
        
        VerticalLayoutContainer verticalLayoutContainer  = new VerticalLayoutContainer();
        framedPanel.add(verticalLayoutContainer);
        
        chart.setLayoutData(new VerticalLayoutData(1, 1));
        verticalLayoutContainer.add(chart);
       
        framedPanel.add(verticalLayoutContainer);
        return framedPanel;
    }
    
    public class ItemsSold {
        private Date date;
        private double asphalt;
        private double cardboard;
        private double cloth;
        private double glass;
        private double metal;
        private double paper;
        private double plastic;
        private double stone;
        private double wood;
        
        public ItemsSold(Date date, double asphalt, double cardboard, double cloth, double glass, double metal, double paper, double plastic, double stone, double wood) {
            this.date = date;
            this.asphalt = asphalt;
            this.cardboard = cardboard;
            this.cloth = cloth;
            this.glass = glass;
            this.metal = metal;            
            this.paper = paper;
            this.metal = metal;
            this.plastic = plastic;
            this.stone = stone;
            this.wood = wood;
        }
        
        public Date getDate() {
            return date;
        }
        
        public double getAsphalt() {
            return asphalt;
        }
        
        public double getCardboard() {
            return cardboard;
        }
        
        public double getCloth() {
            return cloth;
        }
        
        public double getGlass() {
            return glass;
        }
        
        public double getMetal() {
            return metal;
        }
        
        public double getPaper() {
            return paper;
        }
        
        public double getPlastic() {
            return plastic;
        }
        
        public double getStone() {
            return stone;
        }
        
        public double getWood() {
            return wood;
        }
    }
    
    private List<ItemsSold> getData(int size, double min, double scale) {
        List<ItemsSold> data = new ArrayList<ItemsSold>();
        @SuppressWarnings("deprecation")
        Date dateWork = new Date(2011, 6, 1);
        for (int i = 0; i < size + 1; i++) {
            data.add(new ItemsSold(new Date(dateWork.getTime()), Math.floor(Math.max(Math.random() * scale, min)),
                    Math.floor(Math.max(Math.random() * scale, min)), Math.floor(Math.max(Math.random() * scale, min)),
                    Math.floor(Math.max(Math.random() * scale, min)), Math.floor(Math.max(Math.random() * scale, min)),
                    Math.floor(Math.max(Math.random() * scale, min)), Math.floor(Math.max(Math.random() * scale, min)),
                    Math.floor(Math.max(Math.random() * scale, min)), Math.floor(Math.max(Math.random() * scale, min))));
            dateWork = new Date(dateWork.getTime() + 86400000);
        }
        return data;
    }
}
