package com.sencha.gxt.examples.test.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.PropertyAccess;
import com.sencha.gxt.examples.resources.client.TestData;
import com.sencha.gxt.examples.resources.client.model.Stock;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

public class ToolBarTest implements EntryPoint {

  interface StockProperties extends PropertyAccess<Stock> {
    ModelKeyProvider<Stock> symbol();

    LabelProvider<Stock> name();
  }

  
  @Override
  public void onModuleLoad() {
    ToolBar toolBar = new ToolBar();
    
    toolBar.add(new TextButton("Button 1"));
    
    TextButton btn = new TextButton("with menu");
    
    Menu menu = new Menu();
    menu.add(new MenuItem("sdfds"));
    menu.add(new MenuItem("sdfsdfdf"));
    btn.setMenu(menu);
    
    StockProperties props = GWT.create(StockProperties.class);
    ListStore<Stock> store = new ListStore<Stock>(props.symbol());
    store.addAll(TestData.getStocks());

    final ComboBox<Stock> combo = new ComboBox<Stock>(store, props.name());
    combo.setName("name");
    combo.setForceSelection(true);
    combo.setStore(store);
    combo.setTriggerAction(TriggerAction.ALL);
    
    menu.add(combo);
    
    toolBar.add(btn);
    
    RootPanel.get().add(toolBar);
    
    VerticalPanel vp = new VerticalPanel();
    vp.setHeight("500px");
    RootPanel.get().add(vp);
  }

}
