package com.sencha.gxt.examples.test.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.sencha.gxt.core.client.XTemplates;
import com.sencha.gxt.examples.resources.client.model.ExampleData;
import com.sencha.gxt.examples.resources.client.model.StockProxy;

public class Test implements EntryPoint {

  public interface MyResources extends ClientBundle {

    @Source("test.css")
    MyItemStyle css();
  }

  public interface ItemStyle extends CssResource {
    String item();
  }

  public interface MyItemStyle extends ItemStyle {
    String custom();
  }

  public interface ItemRenderer<T, S extends ItemStyle> {

    SafeHtml renderItem(T item, S style);
  }

  public interface MyItemRenderer extends ItemRenderer<StockProxy, MyItemStyle>, XTemplates {
    @XTemplate("<div class='{style.item} {style.custom}'>{item.name}</div>")
    SafeHtml renderItem(StockProxy item, MyItemStyle style);
  }

  @Override
  public void onModuleLoad() {
    MyResources r = GWT.create(MyResources.class);
    MyItemStyle s = r.css();
    s.ensureInjected();

    MyItemRenderer renderer = GWT.create(MyItemRenderer.class);

    System.out.println(renderer.renderItem(ExampleData.getStocks().get(0), s).asString());

  }
}
