package com.sencha.gxt.examples.resources.client.model;

import java.io.Serializable;
import java.util.Date;

public class Stock implements Serializable {

  private double change;
  private Date date = new Date();
  private String industry = getType();
  private double last;
  private String name;
  private double open;
  private String symbol;
  private boolean split = new Boolean(Math.random() > .5);

  public Stock() {
  }

  public Stock(String name, double open, double change, double pctChange, Date date, String industry) {
    this();
    this.name = name;
    this.open = open;
    this.change = change;
    this.date = date;
    this.industry = industry;
  }

  public Stock(String name, String symbol, double open, double last, Date date) {
    this();
    this.name = name;
    this.symbol = symbol;
    this.change = last - open;
    this.open = open;
    this.last = last;
    this.date = date;
  }

  public double getChange() {
    return change;
  }

  public String getIndustry() {
    return industry;
  }

  public double getLast() {
    return last;
  }

  public Date getLastTrans() {
    return date;
  }

  public String getName() {
    return name;
  }

  public double getOpen() {
    return open;
  }

  /**
   * Read-only property, based on other values
   * 
   * @return the percent change
   */
  public double getPercentChange() {
    return getChange() / getOpen();
  }

  public String getSymbol() {
    return symbol;
  }

  public boolean isSplit() {
    return split;
  }

  public void setChange(double change) {
    this.change = change;
  }

  public void setIndustry(String industry) {
    this.industry = industry;
  }

  public void setLast(double last) {
    this.last = last;
  }

  public void setLastTrans(Date date) {
    this.date = date;
  }

  public void setName(String name) {
    this.name = name;
  }

  public void setOpen(double open) {
    this.open = open;
  }

  public void setSplit(boolean split) {
    this.split = split;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }

  public String toString() {
    return getName();
  }
  
  private String getType() {
    double r = Math.random();
    if (r <= .25) {
      return "Auto";
    } else if (r > .25 && r <= .50) {
      return "Media";
    } else if (r > .5 && r <= .75) {
      return "Medical";
    } else {
      return "Tech";
    }
  }
}
