/**
 * Ext GWT 3.0.0-beta1 - Ext for GWT
 * Copyright(c) 2007-2011, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://sencha.com/license
 */
package com.sencha.gxt.chart.client.chart.series;

import com.google.gwt.i18n.client.NumberFormat;
import com.sencha.gxt.chart.client.chart.RoundNumberProvider;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.widget.core.client.tips.ToolTipConfig;

/**
 * Configuration for {@link Series} tooltip.
 * 
 * @param <M> the data type used by the config
 */
public class SeriesToolTipConfig<M> extends ToolTipConfig {

  private LabelProvider<Number> numericLabelProvider = new RoundNumberProvider<Number>();
  private LabelProvider<M> customLabelProvider;

  /**
   * Returns the custom label provider. Overrides numeric label provider.
   * 
   * @return the custom label provider
   */
  public LabelProvider<M> getCustomLabelProvider() {
    return customLabelProvider;
  }

  /**
   * Returns the numeric label provider.
   * 
   * @return the numeric label provider
   */
  public LabelProvider<Number> getNumericLabelProvider() {
    return numericLabelProvider;
  }

  /**
   * Returns the custom label provider. Overrides numeric label provider.
   * 
   * @param customLabelProvider the custom label provider
   */
  public void setCustomLabelProvider(LabelProvider<M> customLabelProvider) {
    this.customLabelProvider = customLabelProvider;
  }

  /**
   * Sets a {@link NumberFormat} for the numeric label provider.
   * 
   * @param format the number formatter
   */
  public void setNumberFormatProvider(final NumberFormat format) {
    this.numericLabelProvider = new LabelProvider<Number>() {
      @Override
      public String getLabel(Number item) {
        return format.format(item);
      }
    };
  }

  /**
   * Sets the numeric label provider. Uses the appropriate yField on the
   * {@link Series}.
   * 
   * @param numericLabelProvider the numeric label provider
   */
  public void setNumericLabelProvider(LabelProvider<Number> numericLabelProvider) {
    this.numericLabelProvider = numericLabelProvider;
  }

  /**
   * Sets a custom {@link ValueProvider} for the tooltip.
   * 
   * @param valueProvider the custom value provider
   * @param labelProvider the label provider used on the value provider
   */
  public <V> void setValueProvider(final ValueProvider<M, V> valueProvider, final LabelProvider<V> labelProvider) {
    this.customLabelProvider = new LabelProvider<M>() {
      @Override
      public String getLabel(M item) {
        return labelProvider.getLabel(valueProvider.getValue(item));
      }
    };
  }
}
