/**
 * Ext GWT 3.0.0-beta1 - Ext for GWT
 * Copyright(c) 2007-2011, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://sencha.com/license
 */
package com.sencha.gxt.chart.client.chart.series;

import com.google.gwt.i18n.client.NumberFormat;
import com.sencha.gxt.chart.client.chart.RoundNumberProvider;
import com.sencha.gxt.chart.client.chart.series.Series.LabelPosition;
import com.sencha.gxt.chart.client.draw.sprite.Sprite;
import com.sencha.gxt.chart.client.draw.sprite.TextSprite;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.LabelProvider;

/**
 * Configuration for {@link Series} labels.
 * 
 * @param <M> the data type used by the config
 */
public class SeriesLabelConfig<M> {

  private Sprite spriteConfig = new TextSprite();
  private LabelProvider<Number> numericLabelProvider = new RoundNumberProvider<Number>();
  private LabelProvider<M> customLabelProvider;
  private boolean labelContrast = false;
  private LabelPosition labelPosition = LabelPosition.END;
  private SeriesRenderer<M> spriteRenderer;

  /**
   * Returns the custom label provider. Overrides numeric label provider.
   * 
   * @return the custom label provider
   */
  public LabelProvider<M> getCustomLabelProvider() {
    return customLabelProvider;
  }

  /**
   * Returns the position of label on the series.
   * 
   * @return the label position
   */
  public LabelPosition getLabelPosition() {
    return labelPosition;
  }

  /**
   * Returns the numeric label provider.
   * 
   * @return the numeric label provider
   */
  public LabelProvider<Number> getNumericLabelProvider() {
    return numericLabelProvider;
  }

  /**
   * Returns the label sprite configuration.
   * 
   * @return the label sprite configuration
   */
  public Sprite getSpriteConfig() {
    return spriteConfig;
  }

  /**
   * Returns the series renderer used on the sprites of the series.
   * 
   * @return the series renderer used on the sprites of the series
   */
  public SeriesRenderer<M> getSpriteRenderer() {
    return spriteRenderer;
  }

  /**
   * Returns whether or not the label automatically contrasts with its
   * background.
   * 
   * @return true if contrasted
   */
  public boolean isLabelContrast() {
    return labelContrast;
  }

  /**
   * Returns the custom label provider. Overrides numeric label provider.
   * 
   * @param customLabelProvider the custom label provider
   */
  public void setCustomLabelProvider(LabelProvider<M> customLabelProvider) {
    this.customLabelProvider = customLabelProvider;
  }

  /**
   * Sets whether or not the label automatically contrasts with its background.
   * 
   * @param labelContrast true if contrasted
   */
  public void setLabelContrast(boolean labelContrast) {
    this.labelContrast = labelContrast;
  }

  /**
   * Sets the position of label on the series.
   * 
   * @param labelPosition the label position
   */
  public void setLabelPosition(LabelPosition labelPosition) {
    this.labelPosition = labelPosition;
  }

  /**
   * Sets a {@link NumberFormat} for the numeric label provider.
   * 
   * @param format the number formatter
   */
  public void setNumberFormatProvider(final NumberFormat format) {
    this.numericLabelProvider = new LabelProvider<Number>() {
      @Override
      public String getLabel(Number item) {
        return format.format(item);
      }
    };
  }

  /**
   * Sets the numeric label provider. Uses the appropriate yField on the
   * {@link Series}.
   * 
   * @param numericLabelProvider the numeric label provider
   */
  public void setNumericLabelProvider(LabelProvider<Number> numericLabelProvider) {
    this.numericLabelProvider = numericLabelProvider;
  }

  /**
   * Sets the label sprite configuration.
   * 
   * @param spriteConfig sprite configuration
   */
  public void setSpriteConfig(Sprite spriteConfig) {
    this.spriteConfig = spriteConfig;
  }

  /**
   * Sets the series renderer used on the sprites of the series.
   * 
   * @param spriteRenderer the series renderer used on the sprites of the series
   */
  public void setSpriteRenderer(SeriesRenderer<M> spriteRenderer) {
    this.spriteRenderer = spriteRenderer;
  }

  /**
   * Sets a custom {@link ValueProvider} for the label.
   * 
   * @param valueProvider the custom value provider
   * @param labelProvider the label provider used on the value provider
   */
  public <V> void setValueProvider(final ValueProvider<M, V> valueProvider, final LabelProvider<V> labelProvider) {
    this.customLabelProvider = new LabelProvider<M>() {
      @Override
      public String getLabel(M item) {
        return labelProvider.getLabel(valueProvider.getValue(item));
      }
    };
  }
}
