/**
 * Ext GWT 3.0.0-beta1 - Ext for GWT
 * Copyright(c) 2007-2011, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://sencha.com/license
 */
package com.sencha.gxt.chart.client.chart.series;

import com.sencha.gxt.chart.client.draw.DrawFx;
import com.sencha.gxt.chart.client.draw.Scaling;
import com.sencha.gxt.chart.client.draw.sprite.Sprite;

/**
 * Highlighting effects used by {@link ScatterSeries}.
 */
public class ScatterHighlighter implements SeriesHighlighter {

  @Override
  public void hightlight(Sprite sprite) {
    if (sprite.getComponent().isAnimated()) {
      DrawFx.createScalingAnimator(sprite, new Scaling(2, 2, 0, 0)).run(250);
    } else {
      sprite.setScaling(new Scaling(2, 2, 0, 0));
      sprite.redraw();
    }
  }

  @Override
  public void unHightlight(Sprite sprite) {
    if (sprite.getComponent().isAnimated()) {
      DrawFx.createScalingAnimator(sprite, new Scaling(1, 1, 0, 0)).run(250);
    } else {
      sprite.setScaling(new Scaling(1, 1, 0, 0));
      sprite.redraw();
    }
  }

}
