/**
 * Ext GWT 3.0.0-beta1 - Ext for GWT
 * Copyright(c) 2007-2011, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://sencha.com/license
 */
package com.sencha.gxt.chart.client.chart.series;

import com.sencha.gxt.chart.client.draw.Color;
import com.sencha.gxt.chart.client.draw.RGB;
import com.sencha.gxt.chart.client.draw.sprite.Sprite;

/**
 * Highlighting effects used by {@link AreaSeries}.
 */
public class AreaHighlighter implements SeriesHighlighter {

  @Override
  public void hightlight(Sprite sprite) {
    Color fill = sprite.getFill();
    if (fill instanceof RGB) {
      RGB rgb = (RGB) fill;
      sprite.setFill(rgb.getLighter(0.2));
      sprite.redraw();
    }
  }

  @Override
  public void unHightlight(Sprite sprite) {
    Color fill = sprite.getFill();
    if (fill instanceof RGB) {
      RGB rgb = (RGB) fill;
      sprite.setFill(rgb.getDarker(0.2));
      sprite.redraw();
    }
  }

}
