/**
 * Ext GWT 3.0.0-beta1 - Ext for GWT
 * Copyright(c) 2007-2011, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://sencha.com/license
 */
package com.sencha.gxt.chart.client.chart.event;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.sencha.gxt.chart.client.chart.event.SeriesSelectionEvent.SeriesSelectionHandler;
import com.sencha.gxt.chart.client.chart.series.Series;

/**
 * Fired when the {@link Series} is clicked.
 */
public class SeriesSelectionEvent extends GwtEvent<SeriesSelectionHandler> {

  /**
   * A widget that implements this interface is a public source of
   * {@link SeriesSelectionEvent} events.
   */
  public interface HasSeriesSelectionHandlers {

    /**
     * Adds a {@link SeriesSelectionHandler} handler for
     * {@link SeriesSelectionEvent} events.
     * 
     * @param handler the handler
     * @return the registration for the event
     */
    HandlerRegistration addSeriesSelectionHandler(SeriesSelectionHandler handler);
  }

  /**
   * Handler class for {@link SeriesSelectionEvent} events.
   */
  public interface SeriesSelectionHandler extends EventHandler {

    /**
     * Fired when the {@link Series} is clicked.
     * 
     * @param event the fired event
     */
    void onSeriesSelection(SeriesSelectionEvent event);
  }

  /**
   * Handler type.
   */
  private static Type<SeriesSelectionHandler> TYPE;

  /**
   * Gets the type associated with this event.
   * 
   * @return returns the handler type
   */
  public static Type<SeriesSelectionHandler> getType() {
    if (TYPE == null) {
      TYPE = new Type<SeriesSelectionHandler>();
    }
    return TYPE;
  }

  private final Number value;
  private final int index;

  /**
   * Creates a new event with the given value and index.
   * 
   * @param value the value of the series item
   * @param index the index of the series item
   */
  public SeriesSelectionEvent(Number value, int index) {
    this.value = value;
    this.index = index;
  }

  @Override
  public Type<SeriesSelectionHandler> getAssociatedType() {
    return getType();
  }

  /**
   * Returns the index of the series item.
   * 
   * @return the index of the series item
   */
  public int getIndex() {
    return index;
  }

  /**
   * Returns the value of the series item.
   * 
   * @return the value of the series item
   */
  public Number getValue() {
    return value;
  }

  @Override
  protected void dispatch(SeriesSelectionHandler handler) {
    handler.onSeriesSelection(this);
  }

}
