/**
 * Ext GWT 3.0.0-beta1 - Ext for GWT
 * Copyright(c) 2007-2011, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://sencha.com/license
 */
package com.sencha.gxt.chart.client.chart.event;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.sencha.gxt.chart.client.chart.event.SeriesItemOverEvent.SeriesItemOverHandler;
import com.sencha.gxt.chart.client.chart.series.Series;

/**
 * Fired when an item in the {@link Series} is moused over.
 */
public class SeriesItemOverEvent extends GwtEvent<SeriesItemOverHandler> {

  /**
   * A widget that implements this interface is a public source of
   * {@link SeriesItemOverEvent} events.
   */
  public interface HasSeriesItemOverHandlers {

    /**
     * Adds a {@link SeriesItemOverHandler} handler for
     * {@link SeriesItemOverEvent} events.
     * 
     * @param handler the handler
     * @return the registration for the event
     */
    HandlerRegistration addSeriesItemOverHandler(SeriesItemOverHandler handler);
  }

  /**
   * Handler class for {@link SeriesItemOverEvent} events.
   */
  public interface SeriesItemOverHandler extends EventHandler {

    /**
     * Fired when an item in the {@link Series} is moused over.
     * 
     * @param event the fired event
     */
    void onSeriesOverItem(SeriesItemOverEvent event);
  }

  /**
   * Handler type.
   */
  private static Type<SeriesItemOverHandler> TYPE;

  /**
   * Gets the type associated with this event.
   * 
   * @return returns the handler type
   */
  public static Type<SeriesItemOverHandler> getType() {
    if (TYPE == null) {
      TYPE = new Type<SeriesItemOverHandler>();
    }
    return TYPE;
  }

  private final Number value;
  private final int index;

  /**
   * Creates a new event with the given value and index.
   * 
   * @param value the value of the series item
   * @param index the index of the series item
   */
  public SeriesItemOverEvent(Number value, int index) {
    this.value = value;
    this.index = index;
  }

  @Override
  public Type<SeriesItemOverHandler> getAssociatedType() {
    return getType();
  }

  /**
   * Returns the index of the series item.
   * 
   * @return the index of the series item
   */
  public int getIndex() {
    return index;
  }

  /**
   * Returns the value of the series item.
   * 
   * @return the value of the series item
   */
  public Number getValue() {
    return value;
  }

  @Override
  protected void dispatch(SeriesItemOverHandler handler) {
    handler.onSeriesOverItem(this);
  }

}
