/**
 * Ext GWT 3.0.0-beta1 - Ext for GWT
 * Copyright(c) 2007-2011, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://sencha.com/license
 */
package com.sencha.gxt.chart.client.chart.event;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.sencha.gxt.chart.client.chart.event.SeriesItemOutEvent.SeriesItemOutHandler;
import com.sencha.gxt.chart.client.chart.series.Series;

/**
 * Fired when an the mouse leaves an item in the {@link Series}.
 */
public class SeriesItemOutEvent extends GwtEvent<SeriesItemOutHandler> {

  /**
   * A widget that implements this interface is a public source of
   * {@link SeriesItemOutEvent} events.
   */
  public interface HasSeriesItemOutHandlers {

    /**
     * Adds a {@link SeriesItemOutHandler} handler for
     * {@link SeriesItemOutEvent} events.
     * 
     * @param handler the handler
     * @return the registration for the event
     */
    HandlerRegistration addSeriesItemOutHandler(SeriesItemOutHandler handler);
  }

  /**
   * Handler class for {@link SeriesItemOutEvent} events.
   */
  public interface SeriesItemOutHandler extends EventHandler {

    /**
     * Fired when an the mouse leaves an item in the {@link Series}.
     * 
     * @param event the fired event
     */
    void onSeriesLeaveItem(SeriesItemOutEvent event);
  }

  /**
   * Handler type.
   */
  private static Type<SeriesItemOutHandler> TYPE;

  /**
   * Gets the type associated with this event.
   * 
   * @return returns the handler type
   */
  public static Type<SeriesItemOutHandler> getType() {
    if (TYPE == null) {
      TYPE = new Type<SeriesItemOutHandler>();
    }
    return TYPE;
  }

  private final Number value;
  private final int index;

  /**
   * Creates a new event with the given value and index.
   * 
   * @param value the value of the series item
   * @param index the index of the series item
   */
  public SeriesItemOutEvent(Number value, int index) {
    this.value = value;
    this.index = index;
  }

  @Override
  public Type<SeriesItemOutHandler> getAssociatedType() {
    return getType();
  }

  /**
   * Returns the index of the series item.
   * 
   * @return the index of the series item
   */
  public int getIndex() {
    return index;
  }

  /**
   * Returns the value of the series item.
   * 
   * @return the value of the series item
   */
  public Number getValue() {
    return value;
  }

  @Override
  protected void dispatch(SeriesItemOutHandler handler) {
    handler.onSeriesLeaveItem(this);
  }

}
