/**
 * Ext GWT 3.0.0-beta1 - Ext for GWT
 * Copyright(c) 2007-2011, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://sencha.com/license
 */
package com.sencha.gxt.chart.client.chart.event;

import com.google.gwt.event.shared.HandlerRegistration;
import com.sencha.gxt.chart.client.chart.event.SeriesItemOutEvent.SeriesItemOutHandler;
import com.sencha.gxt.chart.client.chart.event.SeriesItemOverEvent.SeriesItemOverHandler;
import com.sencha.gxt.chart.client.chart.event.SeriesSelectionEvent.SeriesSelectionHandler;

/**
 * Aggregating handler interface for:
 * 
 * <dl>
 * <dd>{@link SeriesSelectionEvent}</b></dd>
 * <dd>{@link SeriesItemOutEvent}</b></dd>
 * <dd>{@link SeriesItemOverEvent}</b></dd>
 * </dl>
 */
public interface SeriesHandler extends SeriesSelectionHandler, SeriesItemOutHandler, SeriesItemOverHandler {

  /**
   * A widget that implements this interface is a public source of
   * {@link SeriesSelectionEvent}, {@link SeriesItemOutEvent} and
   * {@link SeriesItemOverEvent} events.
   */
  public interface HasSeriesHandlers {

    /**
     * Adds a {@link SeriesHandler} handler for {@link SeriesSelectionEvent},
     * {@link SeriesItemOutEvent}, {@link SeriesItemOverEvent} events.
     * 
     * @param handler the handler
     * @return the registration for the event
     */
    public HandlerRegistration addSeriesHandler(SeriesHandler handler);

  }
}
