/**
 * Ext GWT 3.0.0-beta1 - Ext for GWT
 * Copyright(c) 2007-2011, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://sencha.com/license
 */
package com.sencha.gxt.chart.client.chart.event;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.sencha.gxt.chart.client.chart.Legend;
import com.sencha.gxt.chart.client.chart.LegendItem;
import com.sencha.gxt.chart.client.chart.event.LegendSelectionEvent.LegendSelectionHandler;

/**
 * Fired when the {@link Legend} is clicked.
 */
public class LegendSelectionEvent extends GwtEvent<LegendSelectionHandler> {

  /**
   * A widget that implements this interface is a public source of
   * {@link LegendSelectionEvent} events.
   */
  public interface HasLegendSelectionHandlers {

    /**
     * Adds a {@link LegendSelectionHandler} handler for
     * {@link LegendSelectionEvent} events.
     * 
     * @param handler the handler
     * @return the registration for the event
     */
    HandlerRegistration addLegendSelectionHandler(LegendSelectionHandler handler);
  }

  /**
   * Handler class for {@link LegendSelectionEvent} events.
   */
  public interface LegendSelectionHandler extends EventHandler {

    /**
     * Fired when the {@link Legend} is clicked.
     * 
     * @param event the fired event
     */
    void onLegendSelection(LegendSelectionEvent event);
  }

  /**
   * Handler type.
   */
  private static Type<LegendSelectionHandler> TYPE;

  /**
   * Gets the type associated with this event.
   * 
   * @return returns the handler type
   */
  public static Type<LegendSelectionHandler> getType() {
    if (TYPE == null) {
      TYPE = new Type<LegendSelectionHandler>();
    }
    return TYPE;
  }

  private final LegendItem<?> item;

  /**
   * Creates a new event with the given legend item.
   * 
   * @param item the legend item that fired the event
   */
  public LegendSelectionEvent(LegendItem<?> item) {
    this.item = item;
  }

  @Override
  public Type<LegendSelectionHandler> getAssociatedType() {
    return getType();
  }

  /**
   * Returns the legend item that fired the event.
   * 
   * @return the legend item that fired the event
   */
  public LegendItem<?> getItem() {
    return item;
  }

  @Override
  protected void dispatch(LegendSelectionHandler handler) {
    handler.onLegendSelection(this);
  }

}
