/**
 * Ext GWT 3.0.0-beta1 - Ext for GWT
 * Copyright(c) 2007-2011, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://sencha.com/license
 */
package com.sencha.gxt.chart.client.chart.event;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.sencha.gxt.chart.client.chart.axis.Axis;
import com.sencha.gxt.chart.client.chart.event.AxisItemOutEvent.AxisItemOutHandler;

/**
 * Fired when an the mouse leaves an item in the {@link Axis}.
 */
public class AxisItemOutEvent extends GwtEvent<AxisItemOutHandler> {

  /**
   * Handler class for {@link AxisItemOutEvent} events.
   */
  public interface AxisItemOutHandler extends EventHandler {

    /**
     * Fired when an the mouse leaves an item in the {@link Axis}.
     * 
     * @param event the fired event
     */
    void onAxisLeaveItem(AxisItemOutEvent event);
  }

  /**
   * A widget that implements this interface is a public source of
   * {@link AxisItemOutEvent} events.
   */
  public interface HasAxisItemOutHandlers {

    /**
     * Adds a {@link AxisItemOutHandler} handler for {@link AxisItemOutEvent}
     * events.
     * 
     * @param handler the handler
     * @return the registration for the event
     */
    HandlerRegistration addAxisItemOutHandler(AxisItemOutHandler handler);
  }

  /**
   * Handler type.
   */
  private static Type<AxisItemOutHandler> TYPE;

  /**
   * Gets the type associated with this event.
   * 
   * @return returns the handler type
   */
  public static Type<AxisItemOutHandler> getType() {
    if (TYPE == null) {
      TYPE = new Type<AxisItemOutHandler>();
    }
    return TYPE;
  }

  private final String value;
  private final int index;

  /**
   * Creates a new event with the given value and index.
   * 
   * @param value the value of the axis item
   * @param index the index of the axis item
   */
  public AxisItemOutEvent(String value, int index) {
    this.value = value;
    this.index = index;
  }

  @Override
  public Type<AxisItemOutHandler> getAssociatedType() {
    return getType();
  }

  /**
   * Returns the index of the axis item.
   * 
   * @return the index of the axis item
   */
  public int getIndex() {
    return index;
  }

  /**
   * Returns the value of the axis item.
   * 
   * @return the value of the axis item
   */
  public String getValue() {
    return value;
  }

  @Override
  protected void dispatch(AxisItemOutHandler handler) {
    handler.onAxisLeaveItem(this);
  }

}
