/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.samaxes.maven.minify.plugin.ProcessCSSFilesTask;
import com.samaxes.maven.minify.plugin.ProcessFilesTask;
import com.samaxes.maven.minify.plugin.ProcessJSFilesTask;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class MinifyMojo
extends AbstractMojo {
    private String webappSourceDir;
    private String webappTargetDir;
    private String cssSourceDir;
    private String jsSourceDir;
    private ArrayList<String> cssSourceFiles;
    private ArrayList<String> jsSourceFiles;
    private ArrayList<String> cssSourceIncludes;
    private ArrayList<String> jsSourceIncludes;
    private ArrayList<String> cssSourceExcludes;
    private ArrayList<String> jsSourceExcludes;
    private String cssTargetDir;
    private String jsTargetDir;
    private String cssFinalFile;
    private String jsFinalFile;
    private String suffix;
    private String charset;
    private int linebreak;
    private boolean nomunge;
    private boolean verbose;
    private boolean preserveAllSemiColons;
    private boolean disableOptimizations;
    private int bufferSize;
    private long timeout;
    private boolean debug;
    private boolean skipMerge;
    private boolean skipMinify;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipMerge && this.skipMinify) {
            this.getLog().warn((CharSequence)"Both merge and minify steps are configured to be skipped.");
            return;
        }
        ArrayList<ProcessFilesTask> processFilesTasks = new ArrayList<ProcessFilesTask>();
        processFilesTasks.add(new ProcessCSSFilesTask(this.getLog(), this.bufferSize, this.debug, this.skipMerge, this.skipMinify, this.webappSourceDir, this.webappTargetDir, this.cssSourceDir, this.cssSourceFiles, this.cssSourceIncludes, this.cssSourceExcludes, this.cssTargetDir, this.cssFinalFile, this.suffix, this.charset, this.linebreak));
        processFilesTasks.add(new ProcessJSFilesTask(this.getLog(), this.bufferSize, this.debug, this.skipMerge, this.skipMinify, this.webappSourceDir, this.webappTargetDir, this.jsSourceDir, this.jsSourceFiles, this.jsSourceIncludes, this.jsSourceExcludes, this.jsTargetDir, this.jsFinalFile, this.suffix, this.charset, this.linebreak, !this.nomunge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations));
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            executor.invokeAll(processFilesTasks);
            executor.shutdown();
            executor.awaitTermination(this.timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }
}

