/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfFiles
implements Enumeration<InputStream> {
    private List<File> files;
    private int current = 0;

    public ListOfFiles(Log log, List<File> files, boolean debug) {
        this.files = files;
        for (File file : files) {
            log.info((CharSequence)("Processing source file [" + (debug ? file.getPath() : file.getName()) + "]."));
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.current < this.files.size();
    }

    @Override
    public InputStream nextElement() {
        FileInputStream is = null;
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException("No more files!");
        }
        File nextElement = this.files.get(this.current);
        ++this.current;
        try {
            is = new FileInputStream(nextElement);
        }
        catch (FileNotFoundException e) {
            throw new NoSuchElementException("The path [" + nextElement.getPath() + "] cannot be found.");
        }
        return is;
    }
}

