/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.listen;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.netflix.curator.framework.listen.Listenable;
import com.netflix.curator.framework.listen.ListenerEntry;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerContainer<T>
implements Listenable<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<T, ListenerEntry<T>> listeners = Maps.newConcurrentMap();

    @Override
    public void addListener(T t) {
        this.addListener(t, (Executor)MoreExecutors.sameThreadExecutor());
    }

    @Override
    public void addListener(T t, Executor executor) {
        this.listeners.put(t, new ListenerEntry<T>(t, executor));
    }

    @Override
    public void removeListener(T t) {
        this.listeners.remove(t);
    }

    public void clear() {
        this.listeners.clear();
    }

    public int size() {
        return this.listeners.size();
    }

    public void forEach(Function<T, Void> function) {
        for (ListenerEntry<T> listenerEntry : this.listeners.values()) {
            try {
                function.apply(listenerEntry.listener);
            }
            catch (Throwable throwable) {
                this.log.error(String.format("Listener (%s) threw an exception", listenerEntry.listener), throwable);
            }
        }
    }
}

