/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathAndBytesable;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.PathAndBytesable;
import com.netflix.curator.framework.api.SetDataBackgroundVersionable;
import com.netflix.curator.framework.api.SetDataBuilder;
import com.netflix.curator.framework.api.transaction.CuratorTransactionBridge;
import com.netflix.curator.framework.api.transaction.OperationType;
import com.netflix.curator.framework.api.transaction.TransactionSetDataBuilder;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.CuratorMultiTransactionRecord;
import com.netflix.curator.framework.imps.CuratorTransactionImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import com.netflix.curator.framework.imps.PathAndBytes;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.data.Stat;

class SetDataBuilderImpl
implements SetDataBuilder,
BackgroundOperation<PathAndBytes> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private int version;
    private boolean compress;

    SetDataBuilderImpl(CuratorFrameworkImpl curatorFrameworkImpl) {
        this.client = curatorFrameworkImpl;
        this.backgrounding = new Backgrounding();
        this.version = -1;
        this.compress = false;
    }

    TransactionSetDataBuilder asTransactionSetDataBuilder(final CuratorTransactionImpl curatorTransactionImpl, final CuratorMultiTransactionRecord curatorMultiTransactionRecord) {
        return new TransactionSetDataBuilder(){

            @Override
            public CuratorTransactionBridge forPath(String string, byte[] byArray) throws Exception {
                String string2 = SetDataBuilderImpl.this.client.fixForNamespace(string);
                curatorMultiTransactionRecord.add(Op.setData((String)string2, (byte[])byArray, (int)SetDataBuilderImpl.this.version), OperationType.SET_DATA, string);
                return curatorTransactionImpl;
            }

            @Override
            public CuratorTransactionBridge forPath(String string) throws Exception {
                return this.forPath(string, SetDataBuilderImpl.this.client.getDefaultData());
            }

            @Override
            public PathAndBytesable<CuratorTransactionBridge> withVersion(int n) {
                SetDataBuilderImpl.this.withVersion(n);
                return this;
            }
        };
    }

    @Override
    public SetDataBackgroundVersionable compressed() {
        this.compress = true;
        return new SetDataBackgroundVersionable(){

            @Override
            public PathAndBytesable<Stat> inBackground() {
                return SetDataBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<Stat> inBackground(Object object) {
                return SetDataBuilderImpl.this.inBackground(object);
            }

            @Override
            public PathAndBytesable<Stat> inBackground(BackgroundCallback backgroundCallback) {
                return SetDataBuilderImpl.this.inBackground(backgroundCallback);
            }

            @Override
            public PathAndBytesable<Stat> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
                return SetDataBuilderImpl.this.inBackground(backgroundCallback, executor);
            }

            @Override
            public Stat forPath(String string, byte[] byArray) throws Exception {
                return SetDataBuilderImpl.this.forPath(string, byArray);
            }

            @Override
            public Stat forPath(String string) throws Exception {
                return SetDataBuilderImpl.this.forPath(string);
            }

            @Override
            public BackgroundPathAndBytesable<Stat> withVersion(int n) {
                return SetDataBuilderImpl.this.withVersion(n);
            }
        };
    }

    @Override
    public BackgroundPathAndBytesable<Stat> withVersion(int n) {
        this.version = n;
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground(BackgroundCallback backgroundCallback) {
        this.backgrounding = new Backgrounding(backgroundCallback);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground(Object object) {
        this.backgrounding = new Backgrounding(object);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, executor);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        final TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("SetDataBuilderImpl-Background");
        this.client.getZooKeeper().setData(operationAndData.getData().getPath(), operationAndData.getData().getData(), this.version, new AsyncCallback.StatCallback(){

            public void processResult(int n, String string, Object object, Stat stat) {
                timeTrace.commit();
                CuratorEventImpl curatorEventImpl = new CuratorEventImpl(SetDataBuilderImpl.this.client, CuratorEventType.SET_DATA, n, string, null, object, stat, null, null, null, null);
                SetDataBuilderImpl.this.client.processBackgroundOperation(operationAndData, curatorEventImpl);
            }
        }, this.backgrounding.getContext());
    }

    @Override
    public Stat forPath(String string) throws Exception {
        return this.forPath(string, this.client.getDefaultData());
    }

    @Override
    public Stat forPath(String string, byte[] byArray) throws Exception {
        if (this.compress) {
            byArray = this.client.getCompressionProvider().compress(string, byArray);
        }
        string = this.client.fixForNamespace(string);
        Stat stat = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<PathAndBytes>(this, new PathAndBytes(string, byArray), this.backgrounding.getCallback(), null), null);
        } else {
            stat = this.pathInForeground(string, byArray);
        }
        return stat;
    }

    int getVersion() {
        return this.version;
    }

    private Stat pathInForeground(final String string, final byte[] byArray) throws Exception {
        TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("SetDataBuilderImpl-Foreground");
        Stat stat = (Stat)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                return SetDataBuilderImpl.this.client.getZooKeeper().setData(string, byArray, SetDataBuilderImpl.this.version);
            }
        });
        timeTrace.commit();
        return stat;
    }
}

