/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.ACLable;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.api.SetACLBuilder;
import com.netflix.curator.framework.imps.ACLing;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

class SetACLBuilderImpl
implements SetACLBuilder,
BackgroundPathable<Stat>,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private ACLing acling;
    private Backgrounding backgrounding;
    private int version;

    SetACLBuilderImpl(CuratorFrameworkImpl curatorFrameworkImpl) {
        this.client = curatorFrameworkImpl;
        this.backgrounding = new Backgrounding();
        this.acling = new ACLing(curatorFrameworkImpl.getAclProvider());
        this.version = -1;
    }

    @Override
    public BackgroundPathable<Stat> withACL(List<ACL> list) {
        this.acling = new ACLing(this.client.getAclProvider(), list);
        return this;
    }

    @Override
    public ACLable<BackgroundPathable<Stat>> withVersion(int n) {
        this.version = n;
        return this;
    }

    @Override
    public Pathable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(Object object) {
        this.backgrounding = new Backgrounding(object);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback backgroundCallback) {
        this.backgrounding = new Backgrounding(backgroundCallback);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, executor);
        return this;
    }

    @Override
    public Stat forPath(String string) throws Exception {
        string = this.client.fixForNamespace(string);
        Stat stat = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, string, this.backgrounding.getCallback(), null), null);
        } else {
            stat = this.pathInForeground(string);
        }
        return stat;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("SetACLBuilderImpl-Background");
        String string = operationAndData.getData();
        this.client.getZooKeeper().setACL(string, this.acling.getAclList(string), this.version, new AsyncCallback.StatCallback(){

            public void processResult(int n, String string, Object object, Stat stat) {
                timeTrace.commit();
                CuratorEventImpl curatorEventImpl = new CuratorEventImpl(SetACLBuilderImpl.this.client, CuratorEventType.SET_DATA, n, string, null, object, stat, null, null, null, null);
                SetACLBuilderImpl.this.client.processBackgroundOperation(operationAndData, curatorEventImpl);
            }
        }, this.backgrounding.getContext());
    }

    private Stat pathInForeground(final String string) throws Exception {
        TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("SetACLBuilderImpl-Foreground");
        Stat stat = (Stat)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                return SetACLBuilderImpl.this.client.getZooKeeper().setACL(string, SetACLBuilderImpl.this.acling.getAclList(string), SetACLBuilderImpl.this.version);
            }
        });
        timeTrace.commit();
        return stat;
    }
}

