/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.imps.BackgroundOperation;

class OperationAndData<T> {
    private final BackgroundOperation<T> operation;
    private final T data;
    private final BackgroundCallback callback;
    private final long startTimeMs = System.currentTimeMillis();
    private final ErrorCallback<T> errorCallback;
    private int retryCount = 0;

    OperationAndData(BackgroundOperation<T> backgroundOperation, T t, BackgroundCallback backgroundCallback, ErrorCallback<T> errorCallback) {
        this.operation = backgroundOperation;
        this.data = t;
        this.callback = backgroundCallback;
        this.errorCallback = errorCallback;
    }

    void callPerformBackgroundOperation() throws Exception {
        this.operation.performBackgroundOperation(this);
    }

    T getData() {
        return this.data;
    }

    long getElapsedTimeMs() {
        return System.currentTimeMillis() - this.startTimeMs;
    }

    int getThenIncrementRetryCount() {
        return this.retryCount++;
    }

    BackgroundCallback getCallback() {
        return this.callback;
    }

    ErrorCallback<T> getErrorCallback() {
        return this.errorCallback;
    }

    static interface ErrorCallback<T> {
        public void retriesExhausted(OperationAndData<T> var1);
    }
}

