/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.framework.api.CompressionProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipCompressionProvider
implements CompressionProvider {
    @Override
    public byte[] compress(String string, byte[] byArray) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.finish();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] decompress(String string, byte[] byArray) throws Exception {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
        byte[] byArray2 = new byte[byArray.length];
        while ((n = gZIPInputStream.read(byArray2, 0, byArray2.length)) >= 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

