/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.GetDataBuilder;
import com.netflix.curator.framework.api.GetDataWatchBackgroundStatable;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.api.WatchPathable;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import com.netflix.curator.framework.imps.Watching;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetDataBuilderImpl
implements GetDataBuilder,
BackgroundOperation<String> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkImpl client;
    private Stat responseStat;
    private Watching watching;
    private Backgrounding backgrounding;
    private boolean decompress;

    GetDataBuilderImpl(CuratorFrameworkImpl curatorFrameworkImpl) {
        this.client = curatorFrameworkImpl;
        this.responseStat = null;
        this.watching = new Watching();
        this.backgrounding = new Backgrounding();
        this.decompress = false;
    }

    @Override
    public GetDataWatchBackgroundStatable decompressed() {
        this.decompress = true;
        return new GetDataWatchBackgroundStatable(){

            @Override
            public Pathable<byte[]> inBackground() {
                return GetDataBuilderImpl.this.inBackground();
            }

            @Override
            public Pathable<byte[]> inBackground(Object object) {
                return GetDataBuilderImpl.this.inBackground(object);
            }

            @Override
            public Pathable<byte[]> inBackground(BackgroundCallback backgroundCallback) {
                return GetDataBuilderImpl.this.inBackground(backgroundCallback);
            }

            @Override
            public Pathable<byte[]> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
                return GetDataBuilderImpl.this.inBackground(backgroundCallback, executor);
            }

            @Override
            public byte[] forPath(String string) throws Exception {
                return GetDataBuilderImpl.this.forPath(string);
            }

            @Override
            public WatchPathable<byte[]> storingStatIn(Stat stat) {
                return GetDataBuilderImpl.this.storingStatIn(stat);
            }

            @Override
            public BackgroundPathable<byte[]> watched() {
                return GetDataBuilderImpl.this.watched();
            }

            @Override
            public BackgroundPathable<byte[]> usingWatcher(Watcher watcher) {
                return GetDataBuilderImpl.this.usingWatcher(watcher);
            }
        };
    }

    @Override
    public WatchPathable<byte[]> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return new WatchPathable<byte[]>(){

            @Override
            public byte[] forPath(String string) throws Exception {
                return GetDataBuilderImpl.this.forPath(string);
            }

            @Override
            public Pathable<byte[]> watched() {
                GetDataBuilderImpl.this.watched();
                return GetDataBuilderImpl.this;
            }

            @Override
            public Pathable<byte[]> usingWatcher(Watcher watcher) {
                GetDataBuilderImpl.this.usingWatcher(watcher);
                return GetDataBuilderImpl.this;
            }
        };
    }

    @Override
    public Pathable<byte[]> inBackground(BackgroundCallback backgroundCallback) {
        this.backgrounding = new Backgrounding(backgroundCallback);
        return this;
    }

    @Override
    public Pathable<byte[]> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, executor);
        return this;
    }

    @Override
    public Pathable<byte[]> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<byte[]> inBackground(Object object) {
        this.backgrounding = new Backgrounding(object);
        return this;
    }

    @Override
    public BackgroundPathable<byte[]> watched() {
        this.watching = new Watching(true);
        return this;
    }

    @Override
    public BackgroundPathable<byte[]> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("GetDataBuilderImpl-Background");
        AsyncCallback.DataCallback dataCallback = new AsyncCallback.DataCallback(){

            public void processResult(int n, String string, Object object, byte[] byArray, Stat stat) {
                timeTrace.commit();
                if (GetDataBuilderImpl.this.decompress) {
                    try {
                        byArray = GetDataBuilderImpl.this.client.getCompressionProvider().decompress(string, byArray);
                    }
                    catch (Exception exception) {
                        GetDataBuilderImpl.this.log.error("Decompressing for path: " + string, (Throwable)exception);
                        n = KeeperException.Code.DATAINCONSISTENCY.intValue();
                    }
                }
                CuratorEventImpl curatorEventImpl = new CuratorEventImpl(GetDataBuilderImpl.this.client, CuratorEventType.GET_DATA, n, string, null, object, stat, byArray, null, null, null);
                GetDataBuilderImpl.this.client.processBackgroundOperation(operationAndData, curatorEventImpl);
            }
        };
        if (this.watching.isWatched()) {
            this.client.getZooKeeper().getData(operationAndData.getData(), true, dataCallback, this.backgrounding.getContext());
        } else {
            this.client.getZooKeeper().getData(operationAndData.getData(), this.watching.getWatcher(), dataCallback, this.backgrounding.getContext());
        }
    }

    @Override
    public byte[] forPath(String string) throws Exception {
        string = this.client.fixForNamespace(string);
        byte[] byArray = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, string, this.backgrounding.getCallback(), null), null);
        } else {
            byArray = this.pathInForeground(string);
        }
        return byArray;
    }

    private byte[] pathInForeground(final String string) throws Exception {
        TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("GetDataBuilderImpl-Foreground");
        byte[] byArray = (byte[])RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                byte[] byArray = GetDataBuilderImpl.this.watching.isWatched() ? GetDataBuilderImpl.this.client.getZooKeeper().getData(string, true, GetDataBuilderImpl.this.responseStat) : GetDataBuilderImpl.this.client.getZooKeeper().getData(string, GetDataBuilderImpl.this.watching.getWatcher(), GetDataBuilderImpl.this.responseStat);
                return byArray;
            }
        });
        timeTrace.commit();
        return this.decompress ? this.client.getCompressionProvider().decompress(string, byArray) : byArray;
    }
}

