/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.google.common.collect.Lists;
import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.GetChildrenBuilder;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.api.WatchPathable;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import com.netflix.curator.framework.imps.Watching;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

class GetChildrenBuilderImpl
implements GetChildrenBuilder,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private Watching watching;
    private Backgrounding backgrounding;
    private Stat responseStat;

    GetChildrenBuilderImpl(CuratorFrameworkImpl curatorFrameworkImpl) {
        this.client = curatorFrameworkImpl;
        this.watching = new Watching();
        this.backgrounding = new Backgrounding();
        this.responseStat = null;
    }

    @Override
    public WatchPathable<List<String>> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return new WatchPathable<List<String>>(){

            @Override
            public List<String> forPath(String string) throws Exception {
                return GetChildrenBuilderImpl.this.forPath(string);
            }

            @Override
            public Pathable<List<String>> watched() {
                GetChildrenBuilderImpl.this.watched();
                return GetChildrenBuilderImpl.this;
            }

            @Override
            public Pathable<List<String>> usingWatcher(Watcher watcher) {
                GetChildrenBuilderImpl.this.usingWatcher(watcher);
                return GetChildrenBuilderImpl.this;
            }
        };
    }

    @Override
    public Pathable<List<String>> inBackground(BackgroundCallback backgroundCallback) {
        this.backgrounding = new Backgrounding(backgroundCallback);
        return this;
    }

    @Override
    public Pathable<List<String>> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, executor);
        return this;
    }

    @Override
    public Pathable<List<String>> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<List<String>> inBackground(Object object) {
        this.backgrounding = new Backgrounding(object);
        return this;
    }

    @Override
    public BackgroundPathable<List<String>> watched() {
        this.watching = new Watching(true);
        return this;
    }

    @Override
    public BackgroundPathable<List<String>> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("GetChildrenBuilderImpl-Background");
        AsyncCallback.Children2Callback children2Callback = new AsyncCallback.Children2Callback(){

            public void processResult(int n, String string, Object object, List<String> arrayList, Stat stat) {
                timeTrace.commit();
                if (arrayList == null) {
                    arrayList = Lists.newArrayList();
                }
                CuratorEventImpl curatorEventImpl = new CuratorEventImpl(GetChildrenBuilderImpl.this.client, CuratorEventType.CHILDREN, n, string, null, object, stat, null, arrayList, null, null);
                GetChildrenBuilderImpl.this.client.processBackgroundOperation(operationAndData, curatorEventImpl);
            }
        };
        if (this.watching.isWatched()) {
            this.client.getZooKeeper().getChildren(operationAndData.getData(), true, children2Callback, this.backgrounding.getContext());
        } else {
            this.client.getZooKeeper().getChildren(operationAndData.getData(), this.watching.getWatcher(), children2Callback, this.backgrounding.getContext());
        }
    }

    @Override
    public List<String> forPath(String string) throws Exception {
        string = this.client.fixForNamespace(string);
        List<String> list = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, string, this.backgrounding.getCallback(), null), null);
        } else {
            list = this.pathInForeground(string);
        }
        return list;
    }

    private List<String> pathInForeground(final String string) throws Exception {
        TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("GetChildrenBuilderImpl-Foreground");
        List list = (List)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                List list = GetChildrenBuilderImpl.this.watching.isWatched() ? GetChildrenBuilderImpl.this.client.getZooKeeper().getChildren(string, true, GetChildrenBuilderImpl.this.responseStat) : GetChildrenBuilderImpl.this.client.getZooKeeper().getChildren(string, GetChildrenBuilderImpl.this.watching.getWatcher(), GetChildrenBuilderImpl.this.responseStat);
                return list;
            }
        });
        timeTrace.commit();
        return list;
    }
}

