/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.api.transaction.CuratorTransaction;
import com.netflix.curator.framework.api.transaction.CuratorTransactionBridge;
import com.netflix.curator.framework.api.transaction.CuratorTransactionFinal;
import com.netflix.curator.framework.api.transaction.CuratorTransactionResult;
import com.netflix.curator.framework.api.transaction.OperationType;
import com.netflix.curator.framework.api.transaction.TransactionCheckBuilder;
import com.netflix.curator.framework.api.transaction.TransactionCreateBuilder;
import com.netflix.curator.framework.api.transaction.TransactionDeleteBuilder;
import com.netflix.curator.framework.api.transaction.TransactionSetDataBuilder;
import com.netflix.curator.framework.imps.CreateBuilderImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.CuratorMultiTransactionRecord;
import com.netflix.curator.framework.imps.DeleteBuilderImpl;
import com.netflix.curator.framework.imps.SetDataBuilderImpl;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.data.Stat;

class CuratorTransactionImpl
implements CuratorTransaction,
CuratorTransactionBridge,
CuratorTransactionFinal {
    private final CuratorFrameworkImpl client;
    private final CuratorMultiTransactionRecord transaction;
    private boolean isCommitted = false;

    CuratorTransactionImpl(CuratorFrameworkImpl curatorFrameworkImpl) {
        this.client = curatorFrameworkImpl;
        this.transaction = new CuratorMultiTransactionRecord();
    }

    @Override
    public CuratorTransactionFinal and() {
        return this;
    }

    @Override
    public TransactionCreateBuilder create() {
        Preconditions.checkArgument((!this.isCommitted ? 1 : 0) != 0);
        return new CreateBuilderImpl(this.client).asTransactionCreateBuilder(this, this.transaction);
    }

    @Override
    public TransactionDeleteBuilder delete() {
        Preconditions.checkArgument((!this.isCommitted ? 1 : 0) != 0);
        return new DeleteBuilderImpl(this.client).asTransactionDeleteBuilder(this, this.transaction);
    }

    @Override
    public TransactionSetDataBuilder setData() {
        Preconditions.checkArgument((!this.isCommitted ? 1 : 0) != 0);
        return new SetDataBuilderImpl(this.client).asTransactionSetDataBuilder(this, this.transaction);
    }

    @Override
    public TransactionCheckBuilder check() {
        Preconditions.checkArgument((!this.isCommitted ? 1 : 0) != 0);
        return new TransactionCheckBuilder(){
            private int version = -1;

            @Override
            public CuratorTransactionBridge forPath(String string) throws Exception {
                String string2 = CuratorTransactionImpl.this.client.fixForNamespace(string);
                CuratorTransactionImpl.this.transaction.add(Op.check((String)string2, (int)this.version), OperationType.CHECK, string);
                return CuratorTransactionImpl.this;
            }

            @Override
            public Pathable<CuratorTransactionBridge> withVersion(int n) {
                this.version = n;
                return this;
            }
        };
    }

    @Override
    public Collection<CuratorTransactionResult> commit() throws Exception {
        Preconditions.checkArgument((!this.isCommitted ? 1 : 0) != 0);
        this.isCommitted = true;
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        List list = (List)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<List<OpResult>>(){

            @Override
            public List<OpResult> call() throws Exception {
                return CuratorTransactionImpl.this.doOperation(atomicBoolean);
            }
        });
        if (list.size() != this.transaction.metadataSize()) {
            throw new IllegalStateException(String.format("Result size (%d) doesn't match input size (%d)", list.size(), this.transaction.metadataSize()));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < list.size(); ++i) {
            OpResult opResult = (OpResult)list.get(i);
            CuratorMultiTransactionRecord.TypeAndPath typeAndPath = this.transaction.getMetadata(i);
            CuratorTransactionResult curatorTransactionResult = this.makeCuratorResult(opResult, typeAndPath);
            builder.add((Object)curatorTransactionResult);
        }
        return builder.build();
    }

    private List<OpResult> doOperation(AtomicBoolean atomicBoolean) throws Exception {
        OpResult opResult;
        List list;
        boolean bl = atomicBoolean.getAndSet(false);
        if (!bl) {
            // empty if block
        }
        if ((list = this.client.getZooKeeper().multi((Iterable)((Object)this.transaction))).size() > 0 && (opResult = (OpResult)list.get(0)).getType() == -1) {
            OpResult.ErrorResult errorResult = (OpResult.ErrorResult)opResult;
            KeeperException.Code code = KeeperException.Code.get((int)errorResult.getErr());
            if (code == null) {
                code = KeeperException.Code.UNIMPLEMENTED;
            }
            throw KeeperException.create((KeeperException.Code)code);
        }
        return list;
    }

    private CuratorTransactionResult makeCuratorResult(OpResult opResult, CuratorMultiTransactionRecord.TypeAndPath typeAndPath) {
        String string = null;
        Stat stat = null;
        switch (opResult.getType()) {
            default: {
                break;
            }
            case 1: {
                OpResult.CreateResult createResult = (OpResult.CreateResult)opResult;
                string = this.client.unfixForNamespace(createResult.getPath());
                break;
            }
            case 5: {
                OpResult.SetDataResult setDataResult = (OpResult.SetDataResult)opResult;
                stat = setDataResult.getStat();
                break;
            }
        }
        return new CuratorTransactionResult(typeAndPath.type, typeAndPath.forPath, string, stat);
    }
}

