/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.CuratorFrameworkFactory;
import com.netflix.curator.framework.api.ACLProvider;
import com.netflix.curator.framework.api.CompressionProvider;
import com.netflix.curator.framework.api.CreateBuilder;
import com.netflix.curator.framework.api.CuratorEvent;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.CuratorListener;
import com.netflix.curator.framework.api.DeleteBuilder;
import com.netflix.curator.framework.api.ExistsBuilder;
import com.netflix.curator.framework.api.GetACLBuilder;
import com.netflix.curator.framework.api.GetChildrenBuilder;
import com.netflix.curator.framework.api.GetDataBuilder;
import com.netflix.curator.framework.api.SetACLBuilder;
import com.netflix.curator.framework.api.SetDataBuilder;
import com.netflix.curator.framework.api.UnhandledErrorListener;
import com.netflix.curator.framework.api.transaction.CuratorTransaction;
import com.netflix.curator.framework.imps.BackgroundSyncImpl;
import com.netflix.curator.framework.imps.CreateBuilderImpl;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorTransactionImpl;
import com.netflix.curator.framework.imps.DeleteBuilderImpl;
import com.netflix.curator.framework.imps.ExistsBuilderImpl;
import com.netflix.curator.framework.imps.FailedDeleteManager;
import com.netflix.curator.framework.imps.GetACLBuilderImpl;
import com.netflix.curator.framework.imps.GetChildrenBuilderImpl;
import com.netflix.curator.framework.imps.GetDataBuilderImpl;
import com.netflix.curator.framework.imps.NonNamespaceFacade;
import com.netflix.curator.framework.imps.OperationAndData;
import com.netflix.curator.framework.imps.SetACLBuilderImpl;
import com.netflix.curator.framework.imps.SetDataBuilderImpl;
import com.netflix.curator.framework.listen.Listenable;
import com.netflix.curator.framework.listen.ListenerContainer;
import com.netflix.curator.framework.state.ConnectionState;
import com.netflix.curator.framework.state.ConnectionStateListener;
import com.netflix.curator.framework.state.ConnectionStateManager;
import com.netflix.curator.utils.EnsurePath;
import com.netflix.curator.utils.ZKPaths;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorFrameworkImpl
implements CuratorFramework {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorZookeeperClient client;
    private final ListenerContainer<CuratorListener> listeners;
    private final ListenerContainer<UnhandledErrorListener> unhandledErrorListeners;
    private final ExecutorService executorService;
    private final BlockingQueue<OperationAndData<?>> backgroundOperations;
    private final String namespace;
    private final EnsurePath ensurePath;
    private final ConnectionStateManager connectionStateManager;
    private final AtomicReference<AuthInfo> authInfo = new AtomicReference();
    private final byte[] defaultData;
    private final FailedDeleteManager failedDeleteManager;
    private final CompressionProvider compressionProvider;
    private final ACLProvider aclProvider;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);

    public CuratorFrameworkImpl(CuratorFrameworkFactory.Builder builder) throws IOException {
        this.client = new CuratorZookeeperClient(builder.getZookeeperFactory(), builder.getEnsembleProvider(), builder.getSessionTimeoutMs(), builder.getConnectionTimeoutMs(), new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                CuratorEventImpl curatorEventImpl = new CuratorEventImpl(CuratorFrameworkImpl.this, CuratorEventType.WATCHED, watchedEvent.getState().getIntValue(), CuratorFrameworkImpl.this.unfixForNamespace(watchedEvent.getPath()), null, null, null, null, null, watchedEvent, null);
                CuratorFrameworkImpl.this.processEvent(curatorEventImpl);
            }
        }, builder.getRetryPolicy());
        this.listeners = new ListenerContainer();
        this.unhandledErrorListeners = new ListenerContainer();
        this.backgroundOperations = new LinkedBlockingQueue();
        this.namespace = builder.getNamespace();
        this.ensurePath = this.namespace != null ? new EnsurePath(ZKPaths.makePath((String)"/", (String)this.namespace)) : null;
        this.executorService = Executors.newFixedThreadPool(2, this.getThreadFactory(builder));
        this.connectionStateManager = new ConnectionStateManager(this, builder.getThreadFactory());
        this.compressionProvider = builder.getCompressionProvider();
        this.aclProvider = builder.getAclProvider();
        byte[] byArray = builder.getDefaultData();
        byte[] byArray2 = this.defaultData = byArray != null ? Arrays.copyOf(byArray, byArray.length) : new byte[]{};
        if (builder.getAuthScheme() != null) {
            this.authInfo.set(new AuthInfo(builder.getAuthScheme(), builder.getAuthValue()));
        }
        this.failedDeleteManager = new FailedDeleteManager(this);
    }

    private ThreadFactory getThreadFactory(CuratorFrameworkFactory.Builder builder) {
        ThreadFactory threadFactory = builder.getThreadFactory();
        if (threadFactory == null) {
            threadFactory = new ThreadFactoryBuilder().setNameFormat("CuratorFramework-%d").build();
        }
        return threadFactory;
    }

    protected CuratorFrameworkImpl(CuratorFrameworkImpl curatorFrameworkImpl) {
        this.client = curatorFrameworkImpl.client;
        this.listeners = curatorFrameworkImpl.listeners;
        this.unhandledErrorListeners = curatorFrameworkImpl.unhandledErrorListeners;
        this.executorService = curatorFrameworkImpl.executorService;
        this.backgroundOperations = curatorFrameworkImpl.backgroundOperations;
        this.connectionStateManager = curatorFrameworkImpl.connectionStateManager;
        this.defaultData = curatorFrameworkImpl.defaultData;
        this.failedDeleteManager = curatorFrameworkImpl.failedDeleteManager;
        this.compressionProvider = curatorFrameworkImpl.compressionProvider;
        this.aclProvider = curatorFrameworkImpl.aclProvider;
        this.namespace = null;
        this.ensurePath = null;
    }

    @Override
    public boolean isStarted() {
        return this.state.get() == State.STARTED;
    }

    @Override
    public void start() {
        this.log.info("Starting");
        if (!this.state.compareAndSet(State.LATENT, State.STARTED)) {
            IllegalStateException illegalStateException = new IllegalStateException();
            this.log.error("Already started", (Throwable)illegalStateException);
            throw illegalStateException;
        }
        try {
            this.client.start();
            this.connectionStateManager.start();
            this.executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CuratorFrameworkImpl.this.backgroundOperationsLoop();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            this.handleBackgroundOperationException(null, exception);
        }
    }

    @Override
    public void close() {
        this.log.debug("Closing");
        if (!this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            IllegalStateException illegalStateException = new IllegalStateException();
            this.log.error("Already closed", (Throwable)illegalStateException);
            throw illegalStateException;
        }
        this.listeners.forEach(new Function<CuratorListener, Void>(){

            public Void apply(CuratorListener curatorListener) {
                CuratorEventImpl curatorEventImpl = new CuratorEventImpl(CuratorFrameworkImpl.this, CuratorEventType.CLOSING, 0, null, null, null, null, null, null, null, null);
                try {
                    curatorListener.eventReceived(CuratorFrameworkImpl.this, curatorEventImpl);
                }
                catch (Exception exception) {
                    CuratorFrameworkImpl.this.log.error("Exception while sending Closing event", (Throwable)exception);
                }
                return null;
            }
        });
        this.listeners.clear();
        this.unhandledErrorListeners.clear();
        this.connectionStateManager.close();
        this.client.close();
        this.executorService.shutdownNow();
    }

    @Override
    public CuratorFramework nonNamespaceView() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new NonNamespaceFacade(this);
    }

    @Override
    public CreateBuilder create() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new CreateBuilderImpl(this);
    }

    @Override
    public DeleteBuilder delete() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new DeleteBuilderImpl(this);
    }

    @Override
    public ExistsBuilder checkExists() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new ExistsBuilderImpl(this);
    }

    @Override
    public GetDataBuilder getData() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new GetDataBuilderImpl(this);
    }

    @Override
    public SetDataBuilder setData() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new SetDataBuilderImpl(this);
    }

    @Override
    public GetChildrenBuilder getChildren() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new GetChildrenBuilderImpl(this);
    }

    @Override
    public GetACLBuilder getACL() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new GetACLBuilderImpl(this);
    }

    @Override
    public SetACLBuilder setACL() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new SetACLBuilderImpl(this);
    }

    @Override
    public CuratorTransaction inTransaction() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new CuratorTransactionImpl(this);
    }

    @Override
    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return this.connectionStateManager.getListenable();
    }

    @Override
    public Listenable<CuratorListener> getCuratorListenable() {
        return this.listeners;
    }

    @Override
    public Listenable<UnhandledErrorListener> getUnhandledErrorListenable() {
        return this.unhandledErrorListeners;
    }

    @Override
    public void sync(String string, Object object) {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        string = this.fixForNamespace(string);
        this.internalSync(this, string, object);
    }

    protected void internalSync(CuratorFrameworkImpl curatorFrameworkImpl, String string, Object object) {
        BackgroundSyncImpl backgroundSyncImpl = new BackgroundSyncImpl(curatorFrameworkImpl, object);
        this.backgroundOperations.offer(new OperationAndData<String>(backgroundSyncImpl, string, null, null));
    }

    @Override
    public CuratorZookeeperClient getZookeeperClient() {
        return this.client;
    }

    @Override
    public EnsurePath newNamespaceAwareEnsurePath(String string) {
        return new EnsurePath(this.fixForNamespace(string));
    }

    ACLProvider getAclProvider() {
        return this.aclProvider;
    }

    FailedDeleteManager getFailedDeleteManager() {
        return this.failedDeleteManager;
    }

    RetryLoop newRetryLoop() {
        return this.client.newRetryLoop();
    }

    ZooKeeper getZooKeeper() throws Exception {
        return this.client.getZooKeeper();
    }

    CompressionProvider getCompressionProvider() {
        return this.compressionProvider;
    }

    <DATA_TYPE> void processBackgroundOperation(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent curatorEvent) {
        boolean bl = false;
        if (curatorEvent == null) {
            bl = true;
        } else if (RetryLoop.shouldRetry((int)curatorEvent.getResultCode())) {
            if (this.client.getRetryPolicy().allowRetry(operationAndData.getThenIncrementRetryCount(), operationAndData.getElapsedTimeMs())) {
                bl = true;
            } else {
                if (operationAndData.getErrorCallback() != null) {
                    operationAndData.getErrorCallback().retriesExhausted(operationAndData);
                }
                KeeperException.Code code = KeeperException.Code.get((int)curatorEvent.getResultCode());
                Object object = null;
                try {
                    object = code != null ? KeeperException.create((KeeperException.Code)code) : null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (object == null) {
                    object = new Exception("Unknown result code: " + curatorEvent.getResultCode());
                }
                this.logError("Background operation retry gave up", (Throwable)object);
            }
        } else if (operationAndData.getCallback() != null) {
            this.sendToBackgroundCallback(operationAndData, curatorEvent);
        } else {
            this.processEvent(curatorEvent);
        }
        if (bl) {
            this.backgroundOperations.offer(operationAndData);
        }
    }

    void logError(String string, final Throwable throwable) {
        if (string == null || string.length() == 0) {
            string = "n/a";
        }
        this.log.error(string, throwable);
        if (throwable instanceof KeeperException.ConnectionLossException) {
            this.connectionStateManager.addStateChange(ConnectionState.LOST);
        }
        final String string2 = string;
        this.unhandledErrorListeners.forEach(new Function<UnhandledErrorListener, Void>(){

            public Void apply(UnhandledErrorListener unhandledErrorListener) {
                unhandledErrorListener.unhandledError(string2, throwable);
                return null;
            }
        });
    }

    String unfixForNamespace(String string) {
        String string2;
        if (this.namespace != null && string != null && string.startsWith(string2 = ZKPaths.makePath((String)this.namespace, null))) {
            string = string.length() > string2.length() ? string.substring(string2.length()) : "/";
        }
        return string;
    }

    String fixForNamespace(String string) {
        if (!this.ensurePath()) {
            return "";
        }
        return ZKPaths.fixForNamespace((String)this.namespace, (String)string);
    }

    byte[] getDefaultData() {
        return this.defaultData;
    }

    private boolean ensurePath() {
        if (this.ensurePath != null) {
            try {
                this.ensurePath.ensure(this.client);
            }
            catch (Exception exception) {
                this.logError("Ensure path threw exception", exception);
                return false;
            }
        }
        return true;
    }

    private <DATA_TYPE> void sendToBackgroundCallback(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent curatorEvent) {
        try {
            operationAndData.getCallback().processResult(this, curatorEvent);
        }
        catch (Exception exception) {
            this.handleBackgroundOperationException(operationAndData, exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <DATA_TYPE> void handleBackgroundOperationException(OperationAndData<DATA_TYPE> operationAndData, Throwable throwable) {
        if (operationAndData != null && RetryLoop.isRetryException((Throwable)throwable)) {
            this.log.debug("Retry-able exception received", throwable);
            if (this.client.getRetryPolicy().allowRetry(operationAndData.getThenIncrementRetryCount(), operationAndData.getElapsedTimeMs())) {
                this.log.debug("Retrying operation");
                this.backgroundOperations.offer(operationAndData);
                return;
            }
            this.log.debug("Retry policy did not allow retry");
            if (operationAndData.getErrorCallback() != null) {
                operationAndData.getErrorCallback().retriesExhausted(operationAndData);
            }
        }
        this.logError("Background exception was not retry-able or retry gave up", throwable);
    }

    private void backgroundOperationsLoop() {
        AuthInfo authInfo = this.authInfo.getAndSet(null);
        if (authInfo != null) {
            try {
                this.client.getZooKeeper().addAuthInfo(authInfo.scheme, authInfo.auth);
            }
            catch (Exception exception) {
                this.logError("addAuthInfo for background operation threw exception", exception);
                return;
            }
        }
        while (!Thread.interrupted()) {
            OperationAndData<?> operationAndData;
            try {
                operationAndData = this.backgroundOperations.take();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
            try {
                operationAndData.callPerformBackgroundOperation();
            }
            catch (Throwable throwable) {
                this.handleBackgroundOperationException(operationAndData, throwable);
            }
        }
    }

    private void processEvent(final CuratorEvent curatorEvent) {
        this.validateConnection(curatorEvent);
        this.listeners.forEach(new Function<CuratorListener, Void>(){

            public Void apply(CuratorListener curatorListener) {
                try {
                    TimeTrace timeTrace = CuratorFrameworkImpl.this.client.startTracer("EventListener");
                    curatorListener.eventReceived(CuratorFrameworkImpl.this, curatorEvent);
                    timeTrace.commit();
                }
                catch (Exception exception) {
                    CuratorFrameworkImpl.this.logError("Event listener threw exception", exception);
                }
                return null;
            }
        });
    }

    private void validateConnection(CuratorEvent curatorEvent) {
        if (curatorEvent.getType() == CuratorEventType.WATCHED) {
            if (curatorEvent.getWatchedEvent().getState() == Watcher.Event.KeeperState.Disconnected) {
                this.connectionStateManager.addStateChange(ConnectionState.SUSPENDED);
                this.internalSync(this, "/", null);
            } else if (curatorEvent.getWatchedEvent().getState() == Watcher.Event.KeeperState.Expired) {
                this.connectionStateManager.addStateChange(ConnectionState.LOST);
            } else if (curatorEvent.getWatchedEvent().getState() == Watcher.Event.KeeperState.SyncConnected) {
                this.connectionStateManager.addStateChange(ConnectionState.RECONNECTED);
            }
        }
    }

    private static class AuthInfo {
        final String scheme;
        final byte[] auth;

        private AuthInfo(String string, byte[] byArray) {
            this.scheme = string;
            this.auth = byArray;
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        STOPPED;

    }
}

