/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import org.apache.zookeeper.AsyncCallback;

class BackgroundSyncImpl
implements BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private final Object context;

    BackgroundSyncImpl(CuratorFrameworkImpl curatorFrameworkImpl, Object object) {
        this.client = curatorFrameworkImpl;
        this.context = object;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("BackgroundSyncImpl");
        this.client.getZooKeeper().sync(operationAndData.getData(), new AsyncCallback.VoidCallback(){

            public void processResult(int n, String string, Object object) {
                timeTrace.commit();
                CuratorEventImpl curatorEventImpl = new CuratorEventImpl(BackgroundSyncImpl.this.client, CuratorEventType.SYNC, n, string, null, object, null, null, null, null, null);
                BackgroundSyncImpl.this.client.processBackgroundOperation(operationAndData, curatorEventImpl);
            }
        }, this.context);
    }
}

