/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework;

import com.netflix.curator.RetryPolicy;
import com.netflix.curator.ensemble.EnsembleProvider;
import com.netflix.curator.ensemble.fixed.FixedEnsembleProvider;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.api.ACLProvider;
import com.netflix.curator.framework.api.CompressionProvider;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.DefaultACLProvider;
import com.netflix.curator.framework.imps.GzipCompressionProvider;
import com.netflix.curator.utils.DefaultZookeeperFactory;
import com.netflix.curator.utils.ZookeeperFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ThreadFactory;

public class CuratorFrameworkFactory {
    private static final int DEFAULT_SESSION_TIMEOUT_MS = 15000;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 10000;
    private static final CompressionProvider DEFAULT_COMPRESSION_PROVIDER = new GzipCompressionProvider();
    private static final DefaultZookeeperFactory DEFAULT_ZOOKEEPER_FACTORY = new DefaultZookeeperFactory();
    private static final DefaultACLProvider DEFAULT_ACL_PROVIDER = new DefaultACLProvider();

    public static Builder builder() {
        return new Builder();
    }

    public static CuratorFramework newClient(String string, RetryPolicy retryPolicy) throws IOException {
        return CuratorFrameworkFactory.newClient(string, 15000, 10000, retryPolicy);
    }

    public static CuratorFramework newClient(String string, int n, int n2, RetryPolicy retryPolicy) throws IOException {
        return CuratorFrameworkFactory.builder().connectString(string).sessionTimeoutMs(n).connectionTimeoutMs(n2).retryPolicy(retryPolicy).build();
    }

    private CuratorFrameworkFactory() {
    }

    static /* synthetic */ CompressionProvider access$100() {
        return DEFAULT_COMPRESSION_PROVIDER;
    }

    static /* synthetic */ DefaultZookeeperFactory access$200() {
        return DEFAULT_ZOOKEEPER_FACTORY;
    }

    static /* synthetic */ DefaultACLProvider access$300() {
        return DEFAULT_ACL_PROVIDER;
    }

    public static class Builder {
        private EnsembleProvider ensembleProvider;
        private int sessionTimeoutMs = 15000;
        private int connectionTimeoutMs = 10000;
        private RetryPolicy retryPolicy;
        private ThreadFactory threadFactory = null;
        private String namespace;
        private String authScheme = null;
        private byte[] authValue = null;
        private byte[] defaultData = new byte[0];
        private CompressionProvider compressionProvider = CuratorFrameworkFactory.access$100();
        private ZookeeperFactory zookeeperFactory = CuratorFrameworkFactory.access$200();
        private ACLProvider aclProvider = CuratorFrameworkFactory.access$300();

        public CuratorFramework build() throws IOException {
            return new CuratorFrameworkImpl(this);
        }

        public Builder authorization(String string, byte[] byArray) {
            this.authScheme = string;
            this.authValue = byArray != null ? Arrays.copyOf(byArray, byArray.length) : null;
            return this;
        }

        public Builder connectString(String string) {
            this.ensembleProvider = new FixedEnsembleProvider(string);
            return this;
        }

        public Builder ensembleProvider(EnsembleProvider ensembleProvider) {
            this.ensembleProvider = ensembleProvider;
            return this;
        }

        public Builder defaultData(byte[] byArray) {
            this.defaultData = byArray != null ? Arrays.copyOf(byArray, byArray.length) : null;
            return this;
        }

        public Builder namespace(String string) {
            this.namespace = string;
            return this;
        }

        public Builder sessionTimeoutMs(int n) {
            this.sessionTimeoutMs = n;
            return this;
        }

        public Builder connectionTimeoutMs(int n) {
            this.connectionTimeoutMs = n;
            return this;
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder compressionProvider(CompressionProvider compressionProvider) {
            this.compressionProvider = compressionProvider;
            return this;
        }

        public Builder zookeeperFactory(ZookeeperFactory zookeeperFactory) {
            this.zookeeperFactory = zookeeperFactory;
            return this;
        }

        public Builder aclProvider(ACLProvider aCLProvider) {
            this.aclProvider = aCLProvider;
            return this;
        }

        public ACLProvider getAclProvider() {
            return this.aclProvider;
        }

        public ZookeeperFactory getZookeeperFactory() {
            return this.zookeeperFactory;
        }

        public CompressionProvider getCompressionProvider() {
            return this.compressionProvider;
        }

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        public EnsembleProvider getEnsembleProvider() {
            return this.ensembleProvider;
        }

        public int getSessionTimeoutMs() {
            return this.sessionTimeoutMs;
        }

        public int getConnectionTimeoutMs() {
            return this.connectionTimeoutMs;
        }

        public RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getAuthScheme() {
            return this.authScheme;
        }

        public byte[] getAuthValue() {
            return this.authValue != null ? Arrays.copyOf(this.authValue, this.authValue.length) : null;
        }

        public byte[] getDefaultData() {
            return this.defaultData;
        }

        private Builder() {
        }
    }
}

