/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.google.common.base.Objects;
import com.mysema.codegen.model.Type;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.TypeResolver;
import com.mysema.util.JavaSyntaxUtils;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Property
implements Comparable<Property> {
    private final EntityType declaringType;
    private final boolean inherited;
    private final List<String> inits;
    private final String name;
    private final String escapedName;
    private final Map<Class<?>, Annotation> annotations = new HashMap();
    private final Type type;

    public Property(EntityType declaringType, String name, Type type) {
        this(declaringType, name, type, Collections.emptyList(), false);
    }

    public Property(EntityType declaringType, String name, Type type, List<String> inits) {
        this(declaringType, name, type, inits, false);
    }

    public Property(EntityType declaringType, String name, Type type, List<String> inits, boolean inherited) {
        this(declaringType, name, JavaSyntaxUtils.isReserved((String)name) ? name + "$" : name, type, inits, inherited);
    }

    public Property(EntityType declaringType, String name, String escapedName, Type type, List<String> inits, boolean inherited) {
        this.declaringType = declaringType;
        this.name = name;
        this.escapedName = escapedName;
        this.type = type;
        this.inits = inits;
        this.inherited = inherited;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.put(annotation.annotationType(), annotation);
    }

    @Override
    public int compareTo(Property o) {
        return this.name.compareToIgnoreCase(o.getName());
    }

    public Property createCopy(EntityType targetModel) {
        if (!this.declaringType.getParameters().isEmpty()) {
            Type newType = TypeResolver.resolve(this.type, (Type)this.declaringType, targetModel);
            if (!newType.equals(this.type) || !newType.getClass().equals(this.type.getClass())) {
                return new Property(targetModel, this.name, newType, this.inits, false);
            }
            return new Property(targetModel, this.name, this.type, this.inits, targetModel.getSuperType() != null);
        }
        return new Property(targetModel, this.name, this.type, this.inits, targetModel.getSuperType() != null);
    }

    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return (T)this.annotations.get(type);
    }

    public Collection<Annotation> getAnnotations() {
        return Collections.unmodifiableCollection(this.annotations.values());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Property) {
            Property p = (Property)o;
            return p.name.equals(this.name) && p.type.equals(this.type);
        }
        return false;
    }

    public EntityType getDeclaringType() {
        return this.declaringType;
    }

    public String getEscapedName() {
        return this.escapedName;
    }

    public List<String> getInits() {
        return this.inits;
    }

    public String getName() {
        return this.name;
    }

    public Type getParameter(int i) {
        return (Type)this.type.getParameters().get(i);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public String toString() {
        return this.declaringType.getFullName() + "." + this.name;
    }
}

