/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.bulkloader;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTableView;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.bulkloader.Destination;
import com.hp.hpl.jena.tdb.store.bulkloader.LoadMonitor;
import com.hp.hpl.jena.tdb.store.bulkloader.LoaderNodeTupleTable;
import java.io.InputStream;
import java.util.List;
import org.openjena.atlas.event.EventType;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotReader;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkLoader {
    public static int DataTickPoint = 50000;
    public static long IndexTickPoint = 100000L;
    public static int superTick = 10;
    private static String baseName = "http://openjena.org/TDB/bulkload/event#";
    public static EventType evStartBulkload = new EventType(baseName + "start-bulkload");
    public static EventType evFinishBulkload = new EventType(baseName + "finish-bulkload");
    public static EventType evStartDataBulkload = new EventType(baseName + "start-bulkload-data");
    public static EventType evFinishDataBulkload = new EventType(baseName + "finish-bulkload-data");
    public static EventType evStartIndexBulkload = new EventType(baseName + "start-bulkload-index");
    public static EventType evFinishIndexBulkload = new EventType(baseName + "finish-bulkload-index");
    private static Logger loadLogger = TDB.logLoader;

    public static void loadDefaultGraph(DatasetGraphTDB dsg, List<String> urls, boolean showProgress) {
        Destination<Triple> dest = BulkLoader.destinationDefaultGraph(dsg, showProgress);
        BulkLoader.loadTriples$(dest, urls);
    }

    public static void loadDefaultGraph(DatasetGraphTDB dsg, InputStream input, boolean showProgress) {
        Destination<Triple> dest = BulkLoader.destinationDefaultGraph(dsg, showProgress);
        BulkLoader.loadTriples$(dest, input);
    }

    private static Destination<Triple> destinationDefaultGraph(DatasetGraphTDB dsg, boolean showProgress) {
        NodeTupleTable ntt = dsg.getTripleTable().getNodeTupleTable();
        return BulkLoader.destination(dsg, ntt, showProgress);
    }

    public static void loadNamedGraph(DatasetGraphTDB dsg, Node graphNode, List<String> urls, boolean showProgress) {
        Destination<Triple> dest = BulkLoader.destinationNamedGraph(dsg, graphNode, showProgress);
        BulkLoader.loadTriples$(dest, urls);
    }

    public static void loadNamedGraph(DatasetGraphTDB dsg, Node graphNode, InputStream input, boolean showProgress) {
        Destination<Triple> dest = BulkLoader.destinationNamedGraph(dsg, graphNode, showProgress);
        BulkLoader.loadTriples$(dest, input);
    }

    public static void loadDataset(DatasetGraphTDB dsg, List<String> urls, boolean showProgress) {
        Destination<Quad> dest = BulkLoader.destinationDataset(dsg, showProgress);
        BulkLoader.loadQuads$(dest, urls);
    }

    public static void loadDataset(DatasetGraphTDB dsg, InputStream input, boolean showProgress) {
        Destination<Quad> dest = BulkLoader.destinationDataset(dsg, showProgress);
        BulkLoader.loadQuads$(dest, input);
    }

    private static void loadTriples$(Destination<Triple> dest, List<String> urls) {
        dest.start();
        for (String url : urls) {
            loadLogger.info("Load: " + url + " -- " + Utils.nowAsString());
            RiotReader.parseTriples((String)url, dest);
        }
        dest.finish();
    }

    private static void loadTriples$(Destination<Triple> dest, InputStream input) {
        loadLogger.info("Load: from input stream -- " + Utils.nowAsString());
        dest.start();
        RiotReader.parseTriples((InputStream)input, (Lang)Lang.NTRIPLES, null, dest);
        dest.finish();
    }

    private static void loadQuads$(Destination<Quad> dest, List<String> urls) {
        dest.start();
        for (String url : urls) {
            loadLogger.info("Load: " + url + " -- " + Utils.nowAsString());
            RiotReader.parseQuads((String)url, dest);
        }
        dest.finish();
    }

    private static void loadQuads$(Destination<Quad> dest, InputStream input) {
        loadLogger.info("Load: from input stream -- " + Utils.nowAsString());
        dest.start();
        RiotReader.parseQuads((InputStream)input, (Lang)Lang.NQUADS, null, dest);
        dest.finish();
    }

    private static Destination<Triple> destinationNamedGraph(DatasetGraphTDB dsg, Node graphName, boolean showProgress) {
        if (graphName == null) {
            return BulkLoader.destinationDefaultGraph(dsg, showProgress);
        }
        NodeTupleTable ntt = dsg.getQuadTable().getNodeTupleTable();
        NodeTupleTableView ntt2 = new NodeTupleTableView(ntt, graphName);
        return BulkLoader.destination(dsg, ntt2, showProgress);
    }

    private static LoadMonitor createLoadMonitor(DatasetGraphTDB dsg, String itemName, boolean showProgress) {
        if (showProgress) {
            return new LoadMonitor(dsg, loadLogger, itemName, DataTickPoint, IndexTickPoint);
        }
        return new LoadMonitor(dsg, null, itemName, DataTickPoint, IndexTickPoint);
    }

    private static Destination<Triple> destination(DatasetGraphTDB dsg, NodeTupleTable nodeTupleTable, boolean showProgress) {
        LoadMonitor monitor = BulkLoader.createLoadMonitor(dsg, "triples", showProgress);
        final LoaderNodeTupleTable loaderTriples = new LoaderNodeTupleTable(nodeTupleTable, "triples", monitor);
        Destination<Triple> sink = new Destination<Triple>(){
            long count = 0L;

            @Override
            public final void start() {
                loaderTriples.loadStart();
                loaderTriples.loadDataStart();
            }

            public final void send(Triple triple) {
                loaderTriples.load(triple.getSubject(), triple.getPredicate(), triple.getObject());
                ++this.count;
            }

            public final void flush() {
            }

            public void close() {
            }

            @Override
            public final void finish() {
                loaderTriples.loadDataFinish();
                loaderTriples.loadIndexStart();
                loaderTriples.loadIndexFinish();
                loaderTriples.loadFinish();
            }
        };
        return sink;
    }

    private static Destination<Quad> destinationDataset(DatasetGraphTDB dsg, boolean showProgress) {
        LoadMonitor monitor1 = BulkLoader.createLoadMonitor(dsg, "triples", showProgress);
        LoadMonitor monitor2 = BulkLoader.createLoadMonitor(dsg, "quads", showProgress);
        final LoaderNodeTupleTable loaderTriples = new LoaderNodeTupleTable(dsg.getTripleTable().getNodeTupleTable(), "triples", monitor1);
        final LoaderNodeTupleTable loaderQuads = new LoaderNodeTupleTable(dsg.getQuadTable().getNodeTupleTable(), "quads", monitor2);
        Destination<Quad> sink = new Destination<Quad>(){
            long count = 0L;

            @Override
            public final void start() {
                loaderTriples.loadStart();
                loaderQuads.loadStart();
                loaderTriples.loadDataStart();
                loaderQuads.loadDataStart();
            }

            public final void send(Quad quad) {
                if (quad.isTriple() || quad.isDefaultGraph()) {
                    loaderTriples.load(quad.getSubject(), quad.getPredicate(), quad.getObject());
                } else {
                    loaderQuads.load(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
                }
                ++this.count;
            }

            @Override
            public final void finish() {
                loaderTriples.loadDataFinish();
                loaderQuads.loadDataFinish();
                loaderTriples.loadIndexStart();
                loaderQuads.loadIndexStart();
                loaderTriples.loadIndexFinish();
                loaderQuads.loadIndexFinish();
                loaderTriples.loadFinish();
                loaderQuads.loadFinish();
            }

            public final void flush() {
            }

            public final void close() {
            }
        };
        return sink;
    }
}

