/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphCaching;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.core.DatasetPrefixStorage;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.store.GraphNamedTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTriplesTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.TDBMaker;
import com.hp.hpl.jena.update.GraphStore;
import java.util.Iterator;
import java.util.Properties;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.PropertyUtils;
import org.openjena.atlas.lib.Sync;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetGraphTDB
extends DatasetGraphCaching
implements DatasetGraph,
Sync,
Closeable,
GraphStore {
    private TripleTable tripleTable;
    private QuadTable quadTable;
    private DatasetPrefixStorage prefixes;
    private final ReorderTransformation transform;
    private final Location location;
    private final Properties config;
    private GraphTDB effectiveDefaultGraph;
    private boolean closed = false;
    private static Transform<Tuple<NodeId>, NodeId> project0 = new Transform<Tuple<NodeId>, NodeId>(){

        public NodeId convert(Tuple<NodeId> item) {
            return (NodeId)item.get(0);
        }
    };

    public DatasetGraphTDB(TripleTable tripleTable, QuadTable quadTable, DatasetPrefixStorage prefixes, ReorderTransformation transform, Location location, Properties config) {
        this.tripleTable = tripleTable;
        this.quadTable = quadTable;
        this.prefixes = prefixes;
        this.transform = transform;
        this.location = location;
        this.config = config;
        this.effectiveDefaultGraph = this.getDefaultGraphTDB();
    }

    protected DatasetGraphTDB(DatasetGraphTDB other) {
        this(other.tripleTable, other.quadTable, other.prefixes, other.transform, other.location, other.config);
    }

    public DatasetGraphTDB duplicate() {
        return new DatasetGraphTDB(this.tripleTable, this.quadTable, this.prefixes, this.transform, this.location, this.config);
    }

    public QuadTable getQuadTable() {
        return this.quadTable;
    }

    public TripleTable getTripleTable() {
        return this.tripleTable;
    }

    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return DatasetGraphTDB.triples2quadsDftGraph(this.getTripleTable().find(s, p, o));
    }

    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        return this.getQuadTable().find(g, s, p, o);
    }

    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        return this.getQuadTable().find(Node.ANY, s, p, o);
    }

    protected static Iterator<Quad> triples2quadsDftGraph(Iterator<Triple> iter) {
        return DatasetGraphTDB.triples2quads((Node)Quad.tripleInQuad, iter);
    }

    protected void addToDftGraph(Node s, Node p, Node o) {
        this.getTripleTable().add(s, p, o);
    }

    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        this.getQuadTable().add(g, s, p, o);
    }

    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.getTripleTable().delete(s, p, o);
    }

    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.getQuadTable().delete(g, s, p, o);
    }

    public boolean containsGraph(Node graphNode) {
        NodeId graphNodeId = this.quadTable.getNodeTupleTable().getNodeTable().getNodeIdForNode(graphNode);
        if (NodeId.doesNotExist(graphNodeId)) {
            return false;
        }
        Tuple pattern = Tuple.create((Object[])new NodeId[]{graphNodeId, null, null, null});
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().getTupleTable().find((Tuple<NodeId>)pattern);
        boolean result = x.hasNext();
        return result;
    }

    public GraphTDB getDefaultGraphTDB() {
        return (GraphTDB)this.getDefaultGraph();
    }

    public GraphTDB getGraphTDB(Node graphNode) {
        return (GraphTDB)this.getGraph(graphNode);
    }

    protected void _close() {
        this.tripleTable.close();
        this.quadTable.close();
        this.prefixes.close();
        this.tripleTable = null;
        this.quadTable = null;
        this.prefixes = null;
        TDBMaker.releaseDataset(this);
    }

    protected boolean _containsGraph(Node graphNode) {
        NodeId graphNodeId = this.quadTable.getNodeTupleTable().getNodeTable().getNodeIdForNode(graphNode);
        Tuple pattern = Tuple.create((Object[])new NodeId[]{graphNodeId, null, null, null});
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().getTupleTable().find((Tuple<NodeId>)pattern);
        boolean result = x.hasNext();
        return result;
    }

    protected Graph _createDefaultGraph() {
        return new GraphTriplesTDB(this, this.tripleTable, this.prefixes);
    }

    protected Graph _createNamedGraph(Node graphNode) {
        return new GraphNamedTDB(this, graphNode);
    }

    public void setEffectiveDefaultGraph(GraphTDB g) {
        this.effectiveDefaultGraph = g;
    }

    public GraphTDB getEffectiveDefaultGraph() {
        return this.effectiveDefaultGraph;
    }

    public Properties getConfig() {
        return this.config;
    }

    public String getConfigValue(String key) {
        if (this.config == null) {
            return null;
        }
        return this.config.getProperty(key);
    }

    public int getConfigValueAsInt(String key, int dftValue) {
        if (this.config == null) {
            return dftValue;
        }
        return PropertyUtils.getPropertyAsInteger((Properties)this.config, (String)key, (int)dftValue);
    }

    public ReorderTransformation getTransform() {
        return this.transform;
    }

    public DatasetPrefixStorage getPrefixes() {
        return this.prefixes;
    }

    public Iterator<Node> listGraphNodes() {
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().getTupleTable().getIndex(0).all();
        Iter z = Iter.iter(x).map(project0).distinct();
        return NodeLib.nodes(this.quadTable.getNodeTupleTable().getNodeTable(), (Iterator<NodeId>)z);
    }

    public long size() {
        return Iter.count(this.listGraphNodes());
    }

    public boolean isEmpty() {
        return this.getTripleTable().isEmpty() && this.getQuadTable().isEmpty();
    }

    public void clear() {
        this.getTripleTable().clearTriples();
        this.getQuadTable().clearQuads();
    }

    public Location getLocation() {
        return this.location;
    }

    public void sync() {
        this.sync(true);
    }

    public void sync(boolean force) {
        this.tripleTable.sync(force);
        this.quadTable.sync(force);
        this.prefixes.sync(force);
    }

    public void startRequest() {
    }

    public void finishRequest() {
        this.sync(true);
    }

    public Dataset toDataset() {
        return new DatasetImpl((DatasetGraph)this);
    }

    public void addGraph(Node graphName, Graph graph) {
        Graph g = this.getGraph(graphName);
        g.getBulkUpdateHandler().add(graph);
    }

    public void setDefaultGraph(Graph g) {
        throw new UnsupportedOperationException("Can't set default graph via GraphStore on a TDB-backed dataset");
    }
}

