/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleTable;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.lib.TupleLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.iterator.NullIterator;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTupleTableConcrete
implements NodeTupleTable {
    protected final NodeTable nodeTable;
    protected final TupleTable tupleTable;

    public NodeTupleTableConcrete(int N, TupleIndex[] indexes, NodeTable nodeTable) {
        if (indexes.length == 0 || indexes[0] == null) {
            throw new TDBException("A primary index is required");
        }
        for (TupleIndex index : indexes) {
            if (N == index.getTupleLength()) continue;
            throw new TDBException(String.format("Inconsistent: TupleTable width is %d but index %s is %d", N, index.getLabel(), index.getTupleLength()));
        }
        this.tupleTable = new TupleTable(N, indexes);
        this.nodeTable = nodeTable;
    }

    @Override
    public boolean addRow(Node ... nodes) {
        Object[] n = new NodeId[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            n[i] = this.nodeTable.getAllocateNodeId(nodes[i]);
        }
        Tuple t = Tuple.create((Object[])n);
        try {
            return this.tupleTable.add((Tuple<NodeId>)t);
        }
        catch (TDBException ex) {
            String x = NodeLib.format(" ", nodes);
            System.err.println("Bad add for tuple: " + x);
            throw ex;
        }
    }

    @Override
    public boolean deleteRow(Node ... nodes) {
        Object[] n = new NodeId[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            NodeId id = this.idForNode(nodes[i]);
            if (NodeId.doesNotExist(id)) {
                return false;
            }
            n[i] = id;
        }
        Tuple t = Tuple.create((Object[])n);
        return this.tupleTable.delete((Tuple<NodeId>)t);
    }

    @Override
    public Iterator<Tuple<Node>> find(Node ... nodes) {
        Iterator<Tuple<NodeId>> iter1 = this.findAsNodeIds(nodes);
        if (iter1 == null) {
            return new NullIterator();
        }
        Iterator<Tuple<Node>> iter2 = TupleLib.convertToNodes(this.nodeTable, iter1);
        return iter2;
    }

    @Override
    public Iterator<Tuple<NodeId>> findAsNodeIds(Node ... nodes) {
        NodeId[] n = new NodeId[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            NodeId id = this.idForNode(nodes[i]);
            if (NodeId.doesNotExist(id)) {
                return null;
            }
            n[i] = id;
        }
        return this.find(n);
    }

    @Override
    public Iterator<Tuple<NodeId>> find(NodeId ... ids) {
        Tuple tuple = Tuple.create((Object[])ids);
        Iterator<Tuple<NodeId>> iter = this.tupleTable.find((Tuple<NodeId>)tuple);
        return iter;
    }

    protected final NodeId idForNode(Node node) {
        if (node == null || node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        if (node.isVariable()) {
            throw new TDBException("Can't pass variables to NodeTupleTable.find*");
        }
        return this.nodeTable.getNodeIdForNode(node);
    }

    @Override
    public final TupleTable getTupleTable() {
        return this.tupleTable;
    }

    @Override
    public final NodeTable getNodeTable() {
        return this.nodeTable;
    }

    @Override
    public boolean isEmpty() {
        return this.tupleTable.isEmpty();
    }

    @Override
    public void clear() {
        this.tupleTable.clear();
    }

    @Override
    public long size() {
        return this.tupleTable.size();
    }

    public final void close() {
        this.tupleTable.close();
        this.nodeTable.close();
    }

    public final void sync() {
        this.sync(true);
    }

    public final void sync(boolean force) {
        this.tupleTable.sync(force);
        this.nodeTable.sync(force);
    }
}

