/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.migrate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.algebra.table.Table1;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformDynamicDataset
extends TransformCopy {
    private Set<Node> defaultGraphs;
    private Set<Node> defaultGraphsReal;
    private Set<Node> namedGraphs;

    public TransformDynamicDataset(Set<Node> defaultGraphs, Set<Node> namedGraphs, boolean defaultGraphIncludesNamedGraphUnion) {
        this.defaultGraphs = defaultGraphs;
        this.defaultGraphsReal = defaultGraphs;
        this.namedGraphs = namedGraphs;
        if (defaultGraphIncludesNamedGraphUnion) {
            this.defaultGraphs = new HashSet<Node>();
            this.defaultGraphs.addAll(defaultGraphs);
            this.defaultGraphs.addAll(namedGraphs);
        }
    }

    public Op transform(OpBGP op) {
        throw new ARQException("Unexpected use of BGP in for a dynamic dataset");
    }

    public Op transform(OpQuadPattern opQuadPattern) {
        Node gn = opQuadPattern.getGraphNode();
        if (Quad.isQuadDefaultGraphGenerated((Node)gn)) {
            return this.patternOver(this.defaultGraphs, opQuadPattern.getBasicPattern());
        }
        if (gn.equals((Object)Quad.defaultGraphIRI)) {
            return this.patternOver(this.defaultGraphsReal, opQuadPattern.getBasicPattern());
        }
        if (Quad.isQuadUnionGraph((Node)gn)) {
            return this.patternOver(this.namedGraphs, opQuadPattern.getBasicPattern());
        }
        if (gn.isVariable()) {
            if (this.namedGraphs.size() == 0) {
                return OpNull.create();
            }
            Var v = Var.alloc((Node)gn);
            Op union = null;
            for (Node n : this.namedGraphs) {
                Binding b = BindingFactory.binding((Var)v, (Node)n);
                Op x2 = QC.substitute((Op)opQuadPattern, (Binding)b);
                Op op = OpAssign.assign((Op)x2, (Var)v, (Expr)NodeValue.makeNode((Node)n));
                union = OpUnion.create(union, (Op)op);
            }
            return union;
        }
        if (!this.namedGraphs.contains(gn)) {
            return OpNull.create();
        }
        return super.transform(opQuadPattern);
    }

    private Op patternOver(Set<Node> graphs, BasicPattern basicPattern) {
        if (graphs.size() == 0) {
            return OpNull.create();
        }
        Op union = null;
        for (Node n : graphs) {
            OpQuadPattern pattern = new OpQuadPattern(n, basicPattern);
            union = OpUnion.create(union, (Op)pattern);
        }
        if (graphs.size() == 1) {
            return union;
        }
        return new OpDistinct(union);
    }

    public Op transform(OpDatasetNames opDatasetNames) {
        Node gn = opDatasetNames.getGraphNode();
        if (gn.isVariable()) {
            Table t = TableFactory.create();
            Var v = Var.alloc((Node)gn);
            for (Node n : this.namedGraphs) {
                Binding b = BindingFactory.binding((Var)v, (Node)n);
                t.addBinding(b);
            }
            return OpTable.create((Table)t);
        }
        if (!this.namedGraphs.contains(gn)) {
            return OpNull.create();
        }
        return super.transform(opDatasetNames);
    }

    public Op transform(OpGraph opGraph, Op x) {
        Node gn = opGraph.getNode();
        if (this.namedGraphs.size() == 0) {
            return OpNull.create();
        }
        if (gn.isVariable()) {
            Op union = null;
            Var v = Var.alloc((Node)gn);
            for (Node n : this.namedGraphs) {
                OpTable op = OpTable.create((Table)new Table1(v, n));
                op = OpJoin.create((Op)op, (Op)x);
                op = new OpGraph(n, (Op)op);
                union = OpUnion.create(union, (Op)op);
            }
            return union;
        }
        if (!this.namedGraphs.contains(gn)) {
            return OpNull.create();
        }
        return super.transform(opGraph, x);
    }
}

