/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.Sync;
import org.openjena.atlas.lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleTable
implements Sync,
Closeable {
    private static Logger log = LoggerFactory.getLogger(TupleTable.class);
    private final TupleIndex[] indexes;
    private final int tupleLen;

    public TupleTable(int tupleLen, TupleIndex[] indexes) {
        this.tupleLen = tupleLen;
        this.indexes = indexes;
        if (indexes[0] == null) {
            throw new TDBException("TupleTable: no primary index");
        }
        for (TupleIndex index : indexes) {
            if (index == null || index.getTupleLength() == tupleLen) continue;
            throw new TDBException("Incompatible index: " + index.getLabel());
        }
    }

    public boolean add(Tuple<NodeId> t) {
        if (this.tupleLen != t.size()) {
            throw new TDBException(String.format("Mismatch: inserting tuple of length %d into a table of tuples of length %d", t.size(), this.tupleLen));
        }
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] == null || this.indexes[i].add(t)) continue;
            if (i == 0) {
                this.duplicate(t);
                return false;
            }
            throw new TDBException(String.format("Secondary index duplicate: %s -> %s", this.indexes[i].getLabel(), t));
        }
        return true;
    }

    protected void duplicate(Tuple<NodeId> t) {
    }

    public boolean delete(Tuple<NodeId> t) {
        if (this.tupleLen != t.size()) {
            throw new TDBException(String.format("Mismatch: deleting tuple of length %d from a table of tuples of length %d", t.size(), this.tupleLen));
        }
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] == null) continue;
            this.indexes[i].delete(t);
        }
        return true;
    }

    public Iterator<Tuple<NodeId>> find(Tuple<NodeId> pattern) {
        if (this.tupleLen != pattern.size()) {
            throw new TDBException(String.format("Mismatch: finding tuple of length %d in a table of tuples of length %d", pattern.size(), this.tupleLen));
        }
        int numSlots = 0;
        for (int i = 0; i < this.tupleLen; ++i) {
            NodeId x = (NodeId)pattern.get(i);
            if (NodeId.isAny(x)) continue;
            ++numSlots;
        }
        if (numSlots == 0) {
            return this.indexes[0].all();
        }
        int indexNumSlots = 0;
        TupleIndex index = null;
        for (int i = 0; i < this.indexes.length; ++i) {
            int w;
            TupleIndex idx = this.indexes[i];
            if (idx == null || (w = idx.weight(pattern)) <= indexNumSlots) continue;
            indexNumSlots = w;
            index = idx;
        }
        if (index == null) {
            index = this.indexes[0];
        }
        return index.find(pattern);
    }

    public final void close() {
        for (TupleIndex idx : this.indexes) {
            if (idx == null) continue;
            idx.close();
        }
    }

    public void sync() {
        this.sync(true);
    }

    public void sync(boolean force) {
        for (TupleIndex idx : this.indexes) {
            if (idx == null) continue;
            idx.sync(force);
        }
    }

    public boolean isEmpty() {
        return this.indexes[0].isEmpty();
    }

    public void clear() {
        for (TupleIndex idx : this.indexes) {
            if (idx == null) continue;
            idx.clear();
        }
    }

    public long size() {
        return this.indexes[0].size();
    }

    public TupleIndex getIndex(int i) {
        return this.indexes[i];
    }

    public TupleIndex[] getIndexes() {
        return this.indexes;
    }

    public int getTupleLen() {
        return this.tupleLen;
    }

    public void setTupleIndex(int i, TupleIndex index) {
        if (index != null && index.getTupleLength() != this.tupleLen) {
            throw new TDBException("Incompatible index: " + index.getLabel());
        }
        this.indexes[i] = index;
    }

    public int numIndexes() {
        return this.indexes.length;
    }
}

