/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.objectfile;

import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.IteratorInteger;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.ByteBufferLib;
import org.openjena.atlas.lib.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFileMem
implements ObjectFile {
    List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    boolean closed = false;

    public ObjectFileMem(String label) {
    }

    public ObjectFileMem() {
    }

    @Override
    public long length() {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        return this.buffers.size();
    }

    @Override
    public ByteBuffer read(long id) {
        if (id < 0L || id >= (long)this.buffers.size()) {
            throw new IllegalArgumentException("Id " + id + " not in range [0, " + this.buffers.size() + "]");
        }
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        ByteBuffer bb1 = this.buffers.get((int)id);
        ByteBuffer bb2 = ByteBufferLib.duplicate((ByteBuffer)bb1);
        return bb2;
    }

    @Override
    public long write(ByteBuffer bb) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        ByteBuffer bb2 = ByteBufferLib.duplicate((ByteBuffer)bb);
        this.buffers.add(bb2);
        return this.buffers.size() - 1;
    }

    @Override
    public ByteBuffer allocWrite(int maxBytes) {
        return ByteBuffer.allocate(maxBytes);
    }

    @Override
    public long completeWrite(ByteBuffer buffer) {
        return this.write(buffer);
    }

    @Override
    public Iterator<Pair<Long, ByteBuffer>> all() {
        int N = this.buffers.size();
        IteratorInteger iter = new IteratorInteger(0L, (long)N);
        Transform<Long, Pair<Long, ByteBuffer>> transform = new Transform<Long, Pair<Long, ByteBuffer>>(){

            public Pair<Long, ByteBuffer> convert(Long item) {
                ByteBuffer bb = ObjectFileMem.this.buffers.get(item.intValue());
                return new Pair((Object)item, (Object)bb);
            }
        };
        return Iter.map((Iterator)iter, (Transform)transform);
    }

    public void sync() {
    }

    @Override
    public void sync(boolean force) {
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

