/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.file.FileException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.Sync;

public class FileBase
implements Sync,
Closeable {
    public final String filename;
    public final FileChannel channel;
    public final RandomAccessFile out;

    public FileBase(String filename) {
        this.filename = filename;
        try {
            this.out = new RandomAccessFile(filename, "rw");
            this.channel = this.out.getChannel();
        }
        catch (IOException ex) {
            throw new BlockException("Failed to create FileBase", ex);
        }
    }

    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException ex) {
            throw new FileException("FileBase.close", ex);
        }
    }

    public void sync() {
        this.sync(true);
    }

    public void sync(boolean force) {
        try {
            this.channel.force(true);
        }
        catch (IOException ex) {
            throw new FileException("FileBase.sync", ex);
        }
    }
}

