/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrSync;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockMgrWeakRefCache
extends BlockMgrSync {
    private static Logger log = LoggerFactory.getLogger(BlockMgrWeakRefCache.class);
    WeakHashMap<Integer, ByteBuffer> readCache = null;
    WeakHashMap<Integer, ByteBuffer> writeCache = null;
    public static boolean globalLogging = false;
    private boolean logging = false;
    private String indexName;
    long cacheHits = 0L;
    long cacheMisses = 0L;
    long cacheWriteHits = 0L;

    public BlockMgrWeakRefCache(String indexName, int readSlots, int writeSlots, BlockMgr blockMgr) {
        super(blockMgr);
        this.indexName = String.format("%-12s", indexName);
        this.readCache = new WeakHashMap(readSlots, 0.75f);
        if (writeSlots > 0) {
            this.writeCache = new WeakHashMap(writeSlots);
        }
    }

    private void expelEntry(Integer id) {
        ByteBuffer bb = this.writeCache.get(id);
        if (bb == null) {
            log.error("Write cache: " + id + " expeling entry that isn't there");
            return;
        }
        this.log("Drop (write cache): %d", id);
        super.put(id, bb);
        this.writeCache.remove(id);
    }

    public synchronized ByteBuffer get(int id) {
        ByteBuffer bb = this.readCache.get(id);
        if (bb != null) {
            ++this.cacheHits;
            this.log("Hit(r) : %d", id);
            return bb;
        }
        if (this.writeCache != null && (bb = this.writeCache.get(id)) != null) {
            ++this.cacheWriteHits;
            this.log("Hit(w) : %d", id);
            return bb;
        }
        ++this.cacheMisses;
        this.log("Miss  : %d", id);
        bb = super.get(id);
        this.readCache.put(id, bb);
        return bb;
    }

    public synchronized void put(int id, ByteBuffer block) {
        this.log("Put   : %d", id);
        if (this.writeCache != null) {
            this.writeCache.put(id, block);
        } else {
            super.put(id, block);
        }
        this.readCache.put(id, block);
    }

    public synchronized void freeBlock(int id) {
        this.log("Free  : %d", id);
        this.readCache.remove(id);
        if (this.writeCache != null) {
            this.writeCache.remove(id);
        }
        super.freeBlock(id);
    }

    public synchronized void sync(boolean force) {
        String x = "";
        if (this.indexName != null) {
            x = this.indexName + " : ";
        }
        this.log("%sH=%d, M=%d, W=%d", x, this.cacheHits, this.cacheMisses, this.cacheWriteHits);
        if (this.writeCache != null) {
            this.log("sync (%d blocks)", this.writeCache.size());
        } else {
            this.log("sync", new Object[0]);
        }
        boolean somethingWritten = this.syncFlush(force);
        if (somethingWritten) {
            this.log("sync underlying BlockMgr", new Object[0]);
            super.sync(force);
        } else {
            this.log("Empty sync", new Object[0]);
        }
    }

    private void log(String fmt, Object ... args) {
        if (!this.logging && !globalLogging) {
            return;
        }
        String msg = String.format(fmt, args);
        if (this.indexName != null) {
            msg = this.indexName + " : " + msg;
        }
        log.debug(msg);
    }

    public synchronized void close() {
        if (this.writeCache != null) {
            this.log("close (" + this.writeCache.size() + " blocks)", new Object[0]);
        }
        this.syncFlush(true);
        super.close();
    }

    private boolean syncFlush(boolean all) {
        boolean didSync = false;
        if (this.writeCache != null) {
            this.log("Flush (write cache)", new Object[0]);
            long N = this.writeCache.size();
            Integer[] ids = new Integer[(int)N];
            Iterator<Integer> iter = this.writeCache.keySet().iterator();
            if (iter.hasNext()) {
                didSync = true;
            }
            while (iter.hasNext()) {
                Integer id = iter.next();
                this.expelEntry(id);
            }
        }
        return didSync;
    }
}

