/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import arq.cmdline.CmdARQ;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.sparql.util.graph.GraphSink;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.logging.Log;
import org.openjena.riot.Checker;

public class tdbcheck
extends CmdARQ {
    public static void main(String ... argv) {
        TDB.init();
        Log.setLog4j();
        Log.warn(tdbcheck.class, (String)("Deprecated: Use the RIOT commands (part of ARQ) instead: 'riot --sink --time " + Iter.asString(Arrays.asList(argv))));
        new tdbcheck(argv).mainRun();
    }

    protected tdbcheck(String[] argv) {
        super(argv);
    }

    protected String getSummary() {
        return this.getCommandName() + " FILE ...";
    }

    protected void exec() {
        List files = this.getPositional();
        if (files.size() == 0) {
            this.execOne(null);
            return;
        }
        for (String f : files) {
            this.execOne(f);
        }
    }

    private void execOne(String f) {
        GraphCheckingSink g = new GraphCheckingSink();
        Model model = ModelFactory.createModelForGraph((Graph)g);
        if (f != null) {
            if (this.isVerbose()) {
                System.out.println("File: " + f);
            }
            FileManager.get().readModel(model, f);
        } else {
            model.read(System.in, null, "N-TRIPLES");
        }
    }

    private Reader readerISO8859(InputStream inputStream) {
        try {
            return new InputStreamReader(inputStream, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Reader readerASCII(InputStream inputStream) {
        try {
            return new InputStreamReader(inputStream, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }

    class GraphCheckingSink
    extends GraphSink {
        Checker checker = new Checker();

        GraphCheckingSink() {
        }

        public void performAdd(Triple triple) {
            this.checker.check(triple, -1L, -1L);
        }
    }
}

