/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.lib.TupleLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTableConcrete;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.iterator.NullIterator;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.Sync;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadTable
implements Sync,
Closeable {
    final NodeTupleTable table;
    private static Transform<Tuple<Node>, Quad> action = new Transform<Tuple<Node>, Quad>(){

        public Quad convert(Tuple<Node> item) {
            return new Quad((Node)item.get(0), (Node)item.get(1), (Node)item.get(2), (Node)item.get(3));
        }
    };

    public QuadTable(TupleIndex[] indexes, NodeTable nodeTable) {
        this.table = new NodeTupleTableConcrete(4, indexes, nodeTable);
    }

    public boolean add(Quad quad) {
        return this.add(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public boolean add(Node gn, Triple triple) {
        return this.add(gn, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean add(Node g, Node s, Node p, Node o) {
        return this.table.addRow(g, s, p, o);
    }

    public boolean delete(Quad quad) {
        return this.delete(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public boolean delete(Node gn, Triple triple) {
        return this.delete(gn, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean delete(Node g, Node s, Node p, Node o) {
        return this.table.deleteRow(g, s, p, o);
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        Iterator<Tuple<NodeId>> iter = this.table.findAsNodeIds(g, s, p, o);
        if (iter == null) {
            return new NullIterator();
        }
        Iterator<Quad> iter2 = TupleLib.convertToQuads(this.table.getNodeTable(), iter);
        return iter2;
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.table;
    }

    public void sync() {
        this.sync(true);
    }

    public void sync(boolean force) {
        this.table.sync(force);
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public void close() {
        this.table.close();
    }

    public void clearQuads() {
        this.table.getTupleTable().clear();
    }
}

