/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver.stats;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.solver.stats.StatsMatcher;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openjena.atlas.lib.MapUtils;
import org.openjena.atlas.lib.Tuple;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsCollector {
    private static Item ZERO = Item.createNode((Node)NodeFactory.intToNode((int)0));

    public static Item gather(Graph graph) {
        HashMap<Node, Integer> predicates = new HashMap<Node, Integer>(1000);
        long count = 0L;
        ExtendedIterator iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            ++count;
            Node p = t.getPredicate();
            Integer num = (Integer)predicates.get(p);
            if (num == null) {
                predicates.put(p, 1);
                continue;
            }
            predicates.put(p, num + 1);
        }
        return StatsCollector.format(predicates, count);
    }

    public static Item gatherTDB(GraphTDB graph) {
        int idx;
        long count = 0L;
        HashMap<NodeId, Integer> predicateIds = new HashMap<NodeId, Integer>(1000);
        TupleIndex index = graph.getNodeTupleTable().getTupleTable().getIndex(0);
        if (!index.getLabel().equals("SPO->SPO") && !index.getLabel().equals("GSPO->GSPO")) {
            Log.warn(StatsCollector.class, (String)("May not be the right index: " + index.getLabel()));
        }
        Iterator<Tuple<NodeId>> iter = index.all();
        boolean quads = index.getTupleLength() == 4;
        int n = idx = quads ? 2 : 1;
        while (iter.hasNext()) {
            Tuple<NodeId> tuple = iter.next();
            ++count;
            MapUtils.increment(predicateIds, (Object)tuple.get(idx));
        }
        return StatsCollector.statsOutput(graph.getNodeTupleTable().getNodeTable(), predicateIds, count);
    }

    private static Item statsOutput(NodeTable nodeTable, Map<NodeId, Integer> predicateIds, long total) {
        HashMap<Node, Integer> predicates = new HashMap<Node, Integer>(1000);
        for (NodeId p : predicateIds.keySet()) {
            Node n = nodeTable.getNodeForNodeId(p);
            if (n.getURI().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) continue;
            predicates.put(n, predicateIds.get(p));
        }
        return StatsCollector.format(predicates, total);
    }

    public static Item format(Map<Node, Integer> predicates, long count) {
        Item stats = Item.createList();
        ItemList statsList = stats.getList();
        statsList.add("stats");
        Item meta = Item.createTagged((String)"meta");
        Item.addPair((ItemList)meta.getList(), (String)"timestamp", (Node)NodeFactory.nowAsDateTime());
        Item.addPair((ItemList)meta.getList(), (String)"run@", (String)Utils.nowAsString());
        if (count >= 0L) {
            Item.addPair((ItemList)meta.getList(), (String)"count", (Node)NodeFactory.intToNode((int)((int)count)));
        }
        statsList.add(meta);
        for (Map.Entry<Node, Integer> entry : predicates.entrySet()) {
            Item.addPair((ItemList)statsList, (Node)entry.getKey(), (Node)NodeFactory.intToNode((int)entry.getValue()));
        }
        Item.addPair((ItemList)statsList, (Item)StatsMatcher.OTHER, (Item)ZERO);
        return stats;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StatsGraph_OLD
    extends GraphBase {
        long count = 0L;
        Map<Node, Integer> predicates = new HashMap<Node, Integer>(10000);

        protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
            return null;
        }

        public void performAdd(Triple t) {
            ++this.count;
            Node p = t.getPredicate();
            Integer n = this.predicates.get(p);
            if (n == null) {
                this.predicates.put(p, 1);
            } else {
                this.predicates.put(p, n + 1);
            }
        }

        public void printStats() {
            StatsCollector.format(this.predicates, this.count);
        }
    }
}

