/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver.reorder;

import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderFixed;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderProc;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderWeighted;
import com.hp.hpl.jena.tdb.solver.stats.StatsMatcher;

public class ReorderLib {
    private static ReorderProc _identityProc = new ReorderProcIdentity();
    private static ReorderTransformation _identity = new ReorderTransformationIdentity();

    public static ReorderProc identityProc() {
        return _identityProc;
    }

    public static ReorderTransformation identity() {
        return _identity;
    }

    public static ReorderTransformation fixed() {
        return new ReorderFixed();
    }

    public static ReorderTransformation weighted(String filename) {
        StatsMatcher stats = new StatsMatcher(filename);
        return new ReorderWeighted(stats);
    }

    private static class ReorderTransformationIdentity
    implements ReorderTransformation {
        private ReorderTransformationIdentity() {
        }

        public BasicPattern reorder(BasicPattern pattern) {
            return pattern;
        }

        public ReorderProc reorderIndexes(BasicPattern pattern) {
            return _identityProc;
        }
    }

    private static class ReorderProcIdentity
    implements ReorderProc {
        private ReorderProcIdentity() {
        }

        public BasicPattern reorder(BasicPattern pattern) {
            return pattern;
        }

        public String toString() {
            return "identity reorder";
        }
    }
}

